/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GrantOperation {
    DECRYPT("Decrypt"),
    ENCRYPT("Encrypt"),
    GENERATE_DATA_KEY("GenerateDataKey"),
    GENERATE_DATA_KEY_WITHOUT_PLAINTEXT("GenerateDataKeyWithoutPlaintext"),
    RE_ENCRYPT_FROM("ReEncryptFrom"),
    RE_ENCRYPT_TO("ReEncryptTo"),
    SIGN("Sign"),
    VERIFY("Verify"),
    GET_PUBLIC_KEY("GetPublicKey"),
    CREATE_GRANT("CreateGrant"),
    RETIRE_GRANT("RetireGrant"),
    DESCRIBE_KEY("DescribeKey"),
    GENERATE_DATA_KEY_PAIR("GenerateDataKeyPair"),
    GENERATE_DATA_KEY_PAIR_WITHOUT_PLAINTEXT("GenerateDataKeyPairWithoutPlaintext"),
    GENERATE_MAC("GenerateMac"),
    VERIFY_MAC("VerifyMac"),
    DERIVE_SHARED_SECRET("DeriveSharedSecret"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GrantOperation> VALUE_MAP;
    private final String value;

    private GrantOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GrantOperation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GrantOperation> knownValues() {
        EnumSet<GrantOperation> knownValues = EnumSet.allOf(GrantOperation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GrantOperation.class, GrantOperation::toString);
    }
}

