/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;

public class ListKeyPoliciesIterable
implements SdkIterable<ListKeyPoliciesResponse> {
    private final KmsClient client;
    private final ListKeyPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeyPoliciesIterable(KmsClient client, ListKeyPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKeyPoliciesResponseFetcher();
    }

    public Iterator<ListKeyPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> policyNames() {
        Function<ListKeyPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKeyPoliciesResponseFetcher
    implements SyncPageFetcher<ListKeyPoliciesResponse> {
        private ListKeyPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListKeyPoliciesResponse nextPage(ListKeyPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListKeyPoliciesIterable.this.client.listKeyPolicies(ListKeyPoliciesIterable.this.firstRequest);
            }
            return ListKeyPoliciesIterable.this.client.listKeyPolicies((ListKeyPoliciesRequest)((Object)ListKeyPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

