/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;

public class ListKeysIterable
implements SdkIterable<ListKeysResponse> {
    private final KmsClient client;
    private final ListKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeysIterable(KmsClient client, ListKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKeysResponseFetcher();
    }

    public Iterator<ListKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KeyListEntry> keys() {
        Function<ListKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.keys() != null) {
                return response.keys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKeysResponseFetcher
    implements SyncPageFetcher<ListKeysResponse> {
        private ListKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListKeysResponse nextPage(ListKeysResponse previousPage) {
            if (previousPage == null) {
                return ListKeysIterable.this.client.listKeys(ListKeysIterable.this.firstRequest);
            }
            return ListKeysIterable.this.client.listKeys((ListKeysRequest)((Object)ListKeysIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

