/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.DefaultKmsBaseClientBuilder;
import software.amazon.awssdk.services.kms.DefaultKmsClient;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.KmsServiceClientConfiguration;
import software.amazon.awssdk.services.kms.endpoints.KmsEndpointProvider;

@SdkInternalApi
final class DefaultKmsClientBuilder
extends DefaultKmsBaseClientBuilder<KmsClientBuilder, KmsClient>
implements KmsClientBuilder {
    DefaultKmsClientBuilder() {
    }

    @Override
    public DefaultKmsClientBuilder endpointProvider(KmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KmsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKmsClientBuilder.validateClientOptions(clientConfiguration);
        KmsServiceClientConfiguration serviceClientConfiguration = KmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultKmsClient(serviceClientConfiguration, clientConfiguration);
    }
}

