/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;

public class ListKeyPoliciesPublisher
implements SdkPublisher<ListKeyPoliciesResponse> {
    private final KmsAsyncClient client;
    private final ListKeyPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeyPoliciesPublisher(KmsAsyncClient client, ListKeyPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeyPoliciesPublisher(KmsAsyncClient client, ListKeyPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeyPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeyPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> policyNames() {
        Function<ListKeyPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyNames() != null) {
                return response.policyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKeyPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKeyPoliciesResponseFetcher
    implements AsyncPageFetcher<ListKeyPoliciesResponse> {
        private ListKeyPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListKeyPoliciesResponse> nextPage(ListKeyPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListKeyPoliciesPublisher.this.client.listKeyPolicies(ListKeyPoliciesPublisher.this.firstRequest);
            }
            return ListKeyPoliciesPublisher.this.client.listKeyPolicies((ListKeyPoliciesRequest)((Object)ListKeyPoliciesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

