/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.KeyMetadata;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.Tag;
import software.amazon.awssdk.services.kms.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicateKeyResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, ReplicateKeyResponse> {
    private static final SdkField<KeyMetadata> REPLICA_KEY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicaKeyMetadata").getter(ReplicateKeyResponse.getter(ReplicateKeyResponse::replicaKeyMetadata)).setter(ReplicateKeyResponse.setter(Builder::replicaKeyMetadata)).constructor(KeyMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaKeyMetadata").build()}).build();
    private static final SdkField<String> REPLICA_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaPolicy").getter(ReplicateKeyResponse.getter(ReplicateKeyResponse::replicaPolicy)).setter(ReplicateKeyResponse.setter(Builder::replicaPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaPolicy").build()}).build();
    private static final SdkField<List<Tag>> REPLICA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaTags").getter(ReplicateKeyResponse.getter(ReplicateKeyResponse::replicaTags)).setter(ReplicateKeyResponse.setter(Builder::replicaTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICA_KEY_METADATA_FIELD, REPLICA_POLICY_FIELD, REPLICA_TAGS_FIELD));
    private final KeyMetadata replicaKeyMetadata;
    private final String replicaPolicy;
    private final List<Tag> replicaTags;

    private ReplicateKeyResponse(BuilderImpl builder) {
        super(builder);
        this.replicaKeyMetadata = builder.replicaKeyMetadata;
        this.replicaPolicy = builder.replicaPolicy;
        this.replicaTags = builder.replicaTags;
    }

    public final KeyMetadata replicaKeyMetadata() {
        return this.replicaKeyMetadata;
    }

    public final String replicaPolicy() {
        return this.replicaPolicy;
    }

    public final boolean hasReplicaTags() {
        return this.replicaTags != null && !(this.replicaTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> replicaTags() {
        return this.replicaTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaKeyMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicaTags() ? this.replicaTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicateKeyResponse)) {
            return false;
        }
        ReplicateKeyResponse other = (ReplicateKeyResponse)((Object)obj);
        return Objects.equals(this.replicaKeyMetadata(), other.replicaKeyMetadata()) && Objects.equals(this.replicaPolicy(), other.replicaPolicy()) && this.hasReplicaTags() == other.hasReplicaTags() && Objects.equals(this.replicaTags(), other.replicaTags());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicateKeyResponse").add("ReplicaKeyMetadata", (Object)this.replicaKeyMetadata()).add("ReplicaPolicy", (Object)this.replicaPolicy()).add("ReplicaTags", this.hasReplicaTags() ? this.replicaTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicaKeyMetadata": {
                return Optional.ofNullable(clazz.cast(this.replicaKeyMetadata()));
            }
            case "ReplicaPolicy": {
                return Optional.ofNullable(clazz.cast(this.replicaPolicy()));
            }
            case "ReplicaTags": {
                return Optional.ofNullable(clazz.cast(this.replicaTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicateKeyResponse, T> g) {
        return obj -> g.apply((ReplicateKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private KeyMetadata replicaKeyMetadata;
        private String replicaPolicy;
        private List<Tag> replicaTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicateKeyResponse model) {
            super(model);
            this.replicaKeyMetadata(model.replicaKeyMetadata);
            this.replicaPolicy(model.replicaPolicy);
            this.replicaTags(model.replicaTags);
        }

        public final KeyMetadata.Builder getReplicaKeyMetadata() {
            return this.replicaKeyMetadata != null ? this.replicaKeyMetadata.toBuilder() : null;
        }

        @Override
        public final Builder replicaKeyMetadata(KeyMetadata replicaKeyMetadata) {
            this.replicaKeyMetadata = replicaKeyMetadata;
            return this;
        }

        public final void setReplicaKeyMetadata(KeyMetadata.BuilderImpl replicaKeyMetadata) {
            this.replicaKeyMetadata = replicaKeyMetadata != null ? replicaKeyMetadata.build() : null;
        }

        public final String getReplicaPolicy() {
            return this.replicaPolicy;
        }

        @Override
        public final Builder replicaPolicy(String replicaPolicy) {
            this.replicaPolicy = replicaPolicy;
            return this;
        }

        public final void setReplicaPolicy(String replicaPolicy) {
            this.replicaPolicy = replicaPolicy;
        }

        public final List<Tag.Builder> getReplicaTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.replicaTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicaTags(Collection<Tag> replicaTags) {
            this.replicaTags = TagListCopier.copy(replicaTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaTags(Tag ... replicaTags) {
            this.replicaTags(Arrays.asList(replicaTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaTags(Consumer<Tag.Builder> ... replicaTags) {
            this.replicaTags(Stream.of(replicaTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaTags(Collection<Tag.BuilderImpl> replicaTags) {
            this.replicaTags = TagListCopier.copyFromBuilder(replicaTags);
        }

        @Override
        public ReplicateKeyResponse build() {
            return new ReplicateKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplicateKeyResponse> {
        public Builder replicaKeyMetadata(KeyMetadata var1);

        default public Builder replicaKeyMetadata(Consumer<KeyMetadata.Builder> replicaKeyMetadata) {
            return this.replicaKeyMetadata((KeyMetadata)((KeyMetadata.Builder)KeyMetadata.builder().applyMutation(replicaKeyMetadata)).build());
        }

        public Builder replicaPolicy(String var1);

        public Builder replicaTags(Collection<Tag> var1);

        public Builder replicaTags(Tag ... var1);

        public Builder replicaTags(Consumer<Tag.Builder> ... var1);
    }
}

