/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConnectionStateType {
    CONNECTED("CONNECTED"),
    CONNECTING("CONNECTING"),
    FAILED("FAILED"),
    DISCONNECTED("DISCONNECTED"),
    DISCONNECTING("DISCONNECTING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConnectionStateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionStateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConnectionStateType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionStateType> knownValues() {
        return Stream.of(ConnectionStateType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

