/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.MessageType;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, SignRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(SignRequest.getter(SignRequest::keyId)).setter(SignRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Message").getter(SignRequest.getter(SignRequest::message)).setter(SignRequest.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(SignRequest.getter(SignRequest::messageTypeAsString)).setter(SignRequest.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantTokens").getter(SignRequest.getter(SignRequest::grantTokens)).setter(SignRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(SignRequest.getter(SignRequest::signingAlgorithmAsString)).setter(SignRequest.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, MESSAGE_FIELD, MESSAGE_TYPE_FIELD, GRANT_TOKENS_FIELD, SIGNING_ALGORITHM_FIELD));
    private final String keyId;
    private final SdkBytes message;
    private final String messageType;
    private final List<String> grantTokens;
    private final String signingAlgorithm;

    private SignRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.message = builder.message;
        this.messageType = builder.messageType;
        this.grantTokens = builder.grantTokens;
        this.signingAlgorithm = builder.signingAlgorithm;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final SdkBytes message() {
        return this.message;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public final List<String> grantTokens() {
        return this.grantTokens;
    }

    public final SigningAlgorithmSpec signingAlgorithm() {
        return SigningAlgorithmSpec.fromValue(this.signingAlgorithm);
    }

    public final String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTokens() ? this.grantTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignRequest)) {
            return false;
        }
        SignRequest other = (SignRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && this.hasGrantTokens() == other.hasGrantTokens() && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SignRequest").add("KeyId", (Object)this.keyId()).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("MessageType", (Object)this.messageTypeAsString()).add("GrantTokens", this.hasGrantTokens() ? this.grantTokens() : null).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignRequest, T> g) {
        return obj -> g.apply((SignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes message;
        private String messageType;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private String signingAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(SignRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.message(model.message);
            this.messageType(model.messageType);
            this.grantTokens(model.grantTokens);
            this.signingAlgorithm(model.signingAlgorithm);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getMessage() {
            return this.message == null ? null : this.message.asByteBuffer();
        }

        @Override
        public final Builder message(SdkBytes message) {
            this.message = StandardMemberCopier.copy((SdkBytes)message);
            return this;
        }

        public final void setMessage(ByteBuffer message) {
            this.message(message == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)message));
        }

        public final String getMessageType() {
            return this.messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final Collection<String> getGrantTokens() {
            if (this.grantTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithmSpec signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SignRequest build() {
            return new SignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignRequest> {
        public Builder keyId(String var1);

        public Builder message(SdkBytes var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlgorithmSpec var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

