/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AliasListEntry> {
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasName").getter(AliasListEntry.getter(AliasListEntry::aliasName)).setter(AliasListEntry.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()}).build();
    private static final SdkField<String> ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasArn").getter(AliasListEntry.getter(AliasListEntry::aliasArn)).setter(AliasListEntry.setter(Builder::aliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasArn").build()}).build();
    private static final SdkField<String> TARGET_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetKeyId").getter(AliasListEntry.getter(AliasListEntry::targetKeyId)).setter(AliasListEntry.setter(Builder::targetKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetKeyId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(AliasListEntry.getter(AliasListEntry::creationDate)).setter(AliasListEntry.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDate").getter(AliasListEntry.getter(AliasListEntry::lastUpdatedDate)).setter(AliasListEntry.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_NAME_FIELD, ALIAS_ARN_FIELD, TARGET_KEY_ID_FIELD, CREATION_DATE_FIELD, LAST_UPDATED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aliasName;
    private final String aliasArn;
    private final String targetKeyId;
    private final Instant creationDate;
    private final Instant lastUpdatedDate;

    private AliasListEntry(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.aliasArn = builder.aliasArn;
        this.targetKeyId = builder.targetKeyId;
        this.creationDate = builder.creationDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    public final String aliasName() {
        return this.aliasName;
    }

    public final String aliasArn() {
        return this.aliasArn;
    }

    public final String targetKeyId() {
        return this.targetKeyId;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasListEntry)) {
            return false;
        }
        AliasListEntry other = (AliasListEntry)obj;
        return Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.aliasArn(), other.aliasArn()) && Objects.equals(this.targetKeyId(), other.targetKeyId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"AliasListEntry").add("AliasName", (Object)this.aliasName()).add("AliasArn", (Object)this.aliasArn()).add("TargetKeyId", (Object)this.targetKeyId()).add("CreationDate", (Object)this.creationDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
            case "AliasArn": {
                return Optional.ofNullable(clazz.cast(this.aliasArn()));
            }
            case "TargetKeyId": {
                return Optional.ofNullable(clazz.cast(this.targetKeyId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasListEntry, T> g) {
        return obj -> g.apply((AliasListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasName;
        private String aliasArn;
        private String targetKeyId;
        private Instant creationDate;
        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasListEntry model) {
            this.aliasName(model.aliasName);
            this.aliasArn(model.aliasArn);
            this.targetKeyId(model.targetKeyId);
            this.creationDate(model.creationDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getTargetKeyId() {
            return this.targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public AliasListEntry build() {
            return new AliasListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AliasListEntry> {
        public Builder aliasName(String var1);

        public Builder aliasArn(String var1);

        public Builder targetKeyId(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);
    }
}

