/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrantConstraints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrantConstraints> {
    private static final SdkField<Map<String, String>> ENCRYPTION_CONTEXT_SUBSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EncryptionContextSubset").getter(GrantConstraints.getter(GrantConstraints::encryptionContextSubset)).setter(GrantConstraints.setter(Builder::encryptionContextSubset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionContextSubset").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ENCRYPTION_CONTEXT_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EncryptionContextEquals").getter(GrantConstraints.getter(GrantConstraints::encryptionContextEquals)).setter(GrantConstraints.setter(Builder::encryptionContextEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionContextEquals").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_CONTEXT_SUBSET_FIELD, ENCRYPTION_CONTEXT_EQUALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> encryptionContextSubset;
    private final Map<String, String> encryptionContextEquals;

    private GrantConstraints(BuilderImpl builder) {
        this.encryptionContextSubset = builder.encryptionContextSubset;
        this.encryptionContextEquals = builder.encryptionContextEquals;
    }

    public boolean hasEncryptionContextSubset() {
        return this.encryptionContextSubset != null && !(this.encryptionContextSubset instanceof SdkAutoConstructMap);
    }

    public Map<String, String> encryptionContextSubset() {
        return this.encryptionContextSubset;
    }

    public boolean hasEncryptionContextEquals() {
        return this.encryptionContextEquals != null && !(this.encryptionContextEquals instanceof SdkAutoConstructMap);
    }

    public Map<String, String> encryptionContextEquals() {
        return this.encryptionContextEquals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContextSubset());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContextEquals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantConstraints)) {
            return false;
        }
        GrantConstraints other = (GrantConstraints)obj;
        return Objects.equals(this.encryptionContextSubset(), other.encryptionContextSubset()) && Objects.equals(this.encryptionContextEquals(), other.encryptionContextEquals());
    }

    public String toString() {
        return ToString.builder((String)"GrantConstraints").add("EncryptionContextSubset", this.encryptionContextSubset()).add("EncryptionContextEquals", this.encryptionContextEquals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionContextSubset": {
                return Optional.ofNullable(clazz.cast(this.encryptionContextSubset()));
            }
            case "EncryptionContextEquals": {
                return Optional.ofNullable(clazz.cast(this.encryptionContextEquals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantConstraints, T> g) {
        return obj -> g.apply((GrantConstraints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> encryptionContextSubset = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> encryptionContextEquals = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrantConstraints model) {
            this.encryptionContextSubset(model.encryptionContextSubset);
            this.encryptionContextEquals(model.encryptionContextEquals);
        }

        public final Map<String, String> getEncryptionContextSubset() {
            return this.encryptionContextSubset;
        }

        @Override
        public final Builder encryptionContextSubset(Map<String, String> encryptionContextSubset) {
            this.encryptionContextSubset = EncryptionContextTypeCopier.copy(encryptionContextSubset);
            return this;
        }

        public final void setEncryptionContextSubset(Map<String, String> encryptionContextSubset) {
            this.encryptionContextSubset = EncryptionContextTypeCopier.copy(encryptionContextSubset);
        }

        public final Map<String, String> getEncryptionContextEquals() {
            return this.encryptionContextEquals;
        }

        @Override
        public final Builder encryptionContextEquals(Map<String, String> encryptionContextEquals) {
            this.encryptionContextEquals = EncryptionContextTypeCopier.copy(encryptionContextEquals);
            return this;
        }

        public final void setEncryptionContextEquals(Map<String, String> encryptionContextEquals) {
            this.encryptionContextEquals = EncryptionContextTypeCopier.copy(encryptionContextEquals);
        }

        public GrantConstraints build() {
            return new GrantConstraints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrantConstraints> {
        public Builder encryptionContextSubset(Map<String, String> var1);

        public Builder encryptionContextEquals(Map<String, String> var1);
    }
}

