/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomKeyStoreRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, UpdateCustomKeyStoreRequest> {
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomKeyStoreId").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::customKeyStoreId)).setter(UpdateCustomKeyStoreRequest.setter(Builder::customKeyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()}).build();
    private static final SdkField<String> NEW_CUSTOM_KEY_STORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewCustomKeyStoreName").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::newCustomKeyStoreName)).setter(UpdateCustomKeyStoreRequest.setter(Builder::newCustomKeyStoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewCustomKeyStoreName").build()}).build();
    private static final SdkField<String> KEY_STORE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyStorePassword").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::keyStorePassword)).setter(UpdateCustomKeyStoreRequest.setter(Builder::keyStorePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStorePassword").build()}).build();
    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudHsmClusterId").getter(UpdateCustomKeyStoreRequest.getter(UpdateCustomKeyStoreRequest::cloudHsmClusterId)).setter(UpdateCustomKeyStoreRequest.setter(Builder::cloudHsmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_KEY_STORE_ID_FIELD, NEW_CUSTOM_KEY_STORE_NAME_FIELD, KEY_STORE_PASSWORD_FIELD, CLOUD_HSM_CLUSTER_ID_FIELD));
    private final String customKeyStoreId;
    private final String newCustomKeyStoreName;
    private final String keyStorePassword;
    private final String cloudHsmClusterId;

    private UpdateCustomKeyStoreRequest(BuilderImpl builder) {
        super(builder);
        this.customKeyStoreId = builder.customKeyStoreId;
        this.newCustomKeyStoreName = builder.newCustomKeyStoreName;
        this.keyStorePassword = builder.keyStorePassword;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
    }

    public String customKeyStoreId() {
        return this.customKeyStoreId;
    }

    public String newCustomKeyStoreName() {
        return this.newCustomKeyStoreName;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String cloudHsmClusterId() {
        return this.cloudHsmClusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newCustomKeyStoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStorePassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudHsmClusterId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomKeyStoreRequest)) {
            return false;
        }
        UpdateCustomKeyStoreRequest other = (UpdateCustomKeyStoreRequest)((Object)obj);
        return Objects.equals(this.customKeyStoreId(), other.customKeyStoreId()) && Objects.equals(this.newCustomKeyStoreName(), other.newCustomKeyStoreName()) && Objects.equals(this.keyStorePassword(), other.keyStorePassword()) && Objects.equals(this.cloudHsmClusterId(), other.cloudHsmClusterId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCustomKeyStoreRequest").add("CustomKeyStoreId", (Object)this.customKeyStoreId()).add("NewCustomKeyStoreName", (Object)this.newCustomKeyStoreName()).add("KeyStorePassword", (Object)(this.keyStorePassword() == null ? null : "*** Sensitive Data Redacted ***")).add("CloudHsmClusterId", (Object)this.cloudHsmClusterId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomKeyStoreId": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreId()));
            }
            case "NewCustomKeyStoreName": {
                return Optional.ofNullable(clazz.cast(this.newCustomKeyStoreName()));
            }
            case "KeyStorePassword": {
                return Optional.ofNullable(clazz.cast(this.keyStorePassword()));
            }
            case "CloudHsmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudHsmClusterId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomKeyStoreRequest, T> g) {
        return obj -> g.apply((UpdateCustomKeyStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String customKeyStoreId;
        private String newCustomKeyStoreName;
        private String keyStorePassword;
        private String cloudHsmClusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomKeyStoreRequest model) {
            super(model);
            this.customKeyStoreId(model.customKeyStoreId);
            this.newCustomKeyStoreName(model.newCustomKeyStoreName);
            this.keyStorePassword(model.keyStorePassword);
            this.cloudHsmClusterId(model.cloudHsmClusterId);
        }

        public final String getCustomKeyStoreId() {
            return this.customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        public final String getNewCustomKeyStoreName() {
            return this.newCustomKeyStoreName;
        }

        @Override
        public final Builder newCustomKeyStoreName(String newCustomKeyStoreName) {
            this.newCustomKeyStoreName = newCustomKeyStoreName;
            return this;
        }

        public final void setNewCustomKeyStoreName(String newCustomKeyStoreName) {
            this.newCustomKeyStoreName = newCustomKeyStoreName;
        }

        public final String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        @Override
        public final Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public final void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public final String getCloudHsmClusterId() {
            return this.cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomKeyStoreRequest build() {
            return new UpdateCustomKeyStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomKeyStoreRequest> {
        public Builder customKeyStoreId(String var1);

        public Builder newCustomKeyStoreName(String var1);

        public Builder keyStorePassword(String var1);

        public Builder cloudHsmClusterId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

