/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.CustomKeyStoresListCopier;
import software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomKeyStoresResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, DescribeCustomKeyStoresResponse> {
    private static final SdkField<List<CustomKeyStoresListEntry>> CUSTOM_KEY_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomKeyStores").getter(DescribeCustomKeyStoresResponse.getter(DescribeCustomKeyStoresResponse::customKeyStores)).setter(DescribeCustomKeyStoresResponse.setter(Builder::customKeyStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomKeyStoresListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(DescribeCustomKeyStoresResponse.getter(DescribeCustomKeyStoresResponse::nextMarker)).setter(DescribeCustomKeyStoresResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Truncated").getter(DescribeCustomKeyStoresResponse.getter(DescribeCustomKeyStoresResponse::truncated)).setter(DescribeCustomKeyStoresResponse.setter(Builder::truncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truncated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_KEY_STORES_FIELD, NEXT_MARKER_FIELD, TRUNCATED_FIELD));
    private final List<CustomKeyStoresListEntry> customKeyStores;
    private final String nextMarker;
    private final Boolean truncated;

    private DescribeCustomKeyStoresResponse(BuilderImpl builder) {
        super(builder);
        this.customKeyStores = builder.customKeyStores;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public boolean hasCustomKeyStores() {
        return this.customKeyStores != null && !(this.customKeyStores instanceof SdkAutoConstructList);
    }

    public List<CustomKeyStoresListEntry> customKeyStores() {
        return this.customKeyStores;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomKeyStores() ? this.customKeyStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomKeyStoresResponse)) {
            return false;
        }
        DescribeCustomKeyStoresResponse other = (DescribeCustomKeyStoresResponse)((Object)obj);
        return this.hasCustomKeyStores() == other.hasCustomKeyStores() && Objects.equals(this.customKeyStores(), other.customKeyStores()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.truncated(), other.truncated());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCustomKeyStoresResponse").add("CustomKeyStores", this.hasCustomKeyStores() ? this.customKeyStores() : null).add("NextMarker", (Object)this.nextMarker()).add("Truncated", (Object)this.truncated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomKeyStores": {
                return Optional.ofNullable(clazz.cast(this.customKeyStores()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomKeyStoresResponse, T> g) {
        return obj -> g.apply((DescribeCustomKeyStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private List<CustomKeyStoresListEntry> customKeyStores = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomKeyStoresResponse model) {
            super(model);
            this.customKeyStores(model.customKeyStores);
            this.nextMarker(model.nextMarker);
            this.truncated(model.truncated);
        }

        public final Collection<CustomKeyStoresListEntry.Builder> getCustomKeyStores() {
            if (this.customKeyStores instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customKeyStores != null ? (Collection)this.customKeyStores.stream().map(CustomKeyStoresListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customKeyStores(Collection<CustomKeyStoresListEntry> customKeyStores) {
            this.customKeyStores = CustomKeyStoresListCopier.copy(customKeyStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKeyStores(CustomKeyStoresListEntry ... customKeyStores) {
            this.customKeyStores(Arrays.asList(customKeyStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKeyStores(Consumer<CustomKeyStoresListEntry.Builder> ... customKeyStores) {
            this.customKeyStores(Stream.of(customKeyStores).map(c -> (CustomKeyStoresListEntry)((CustomKeyStoresListEntry.Builder)CustomKeyStoresListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomKeyStores(Collection<CustomKeyStoresListEntry.BuilderImpl> customKeyStores) {
            this.customKeyStores = CustomKeyStoresListCopier.copyFromBuilder(customKeyStores);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public DescribeCustomKeyStoresResponse build() {
            return new DescribeCustomKeyStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomKeyStoresResponse> {
        public Builder customKeyStores(Collection<CustomKeyStoresListEntry> var1);

        public Builder customKeyStores(CustomKeyStoresListEntry ... var1);

        public Builder customKeyStores(Consumer<CustomKeyStoresListEntry.Builder> ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

