/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantConstraints;
import software.amazon.awssdk.services.kms.model.GrantOperation;
import software.amazon.awssdk.services.kms.model.GrantOperationListCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGrantRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, CreateGrantRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGrantRequest.getter(CreateGrantRequest::keyId)).setter(CreateGrantRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> GRANTEE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGrantRequest.getter(CreateGrantRequest::granteePrincipal)).setter(CreateGrantRequest.setter(Builder::granteePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteePrincipal").build()}).build();
    private static final SdkField<String> RETIRING_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGrantRequest.getter(CreateGrantRequest::retiringPrincipal)).setter(CreateGrantRequest.setter(Builder::retiringPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetiringPrincipal").build()}).build();
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateGrantRequest.getter(CreateGrantRequest::operationsAsStrings)).setter(CreateGrantRequest.setter(Builder::operationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GrantConstraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateGrantRequest.getter(CreateGrantRequest::constraints)).setter(CreateGrantRequest.setter(Builder::constraints)).constructor(GrantConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateGrantRequest.getter(CreateGrantRequest::grantTokens)).setter(CreateGrantRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateGrantRequest.getter(CreateGrantRequest::name)).setter(CreateGrantRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, GRANTEE_PRINCIPAL_FIELD, RETIRING_PRINCIPAL_FIELD, OPERATIONS_FIELD, CONSTRAINTS_FIELD, GRANT_TOKENS_FIELD, NAME_FIELD));
    private final String keyId;
    private final String granteePrincipal;
    private final String retiringPrincipal;
    private final List<String> operations;
    private final GrantConstraints constraints;
    private final List<String> grantTokens;
    private final String name;

    private CreateGrantRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.operations = builder.operations;
        this.constraints = builder.constraints;
        this.grantTokens = builder.grantTokens;
        this.name = builder.name;
    }

    public String keyId() {
        return this.keyId;
    }

    public String granteePrincipal() {
        return this.granteePrincipal;
    }

    public String retiringPrincipal() {
        return this.retiringPrincipal;
    }

    public List<GrantOperation> operations() {
        return GrantOperationListCopier.copyStringToEnum(this.operations);
    }

    public boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public List<String> operationsAsStrings() {
        return this.operations;
    }

    public GrantConstraints constraints() {
        return this.constraints;
    }

    public boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.retiringPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantRequest)) {
            return false;
        }
        CreateGrantRequest other = (CreateGrantRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.granteePrincipal(), other.granteePrincipal()) && Objects.equals(this.retiringPrincipal(), other.retiringPrincipal()) && Objects.equals(this.operationsAsStrings(), other.operationsAsStrings()) && Objects.equals(this.constraints(), other.constraints()) && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CreateGrantRequest").add("KeyId", (Object)this.keyId()).add("GranteePrincipal", (Object)this.granteePrincipal()).add("RetiringPrincipal", (Object)this.retiringPrincipal()).add("Operations", this.operationsAsStrings()).add("Constraints", (Object)this.constraints()).add("GrantTokens", this.grantTokens()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "GranteePrincipal": {
                return Optional.ofNullable(clazz.cast(this.granteePrincipal()));
            }
            case "RetiringPrincipal": {
                return Optional.ofNullable(clazz.cast(this.retiringPrincipal()));
            }
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operationsAsStrings()));
            }
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantRequest, T> g) {
        return obj -> g.apply((CreateGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private String granteePrincipal;
        private String retiringPrincipal;
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private GrantConstraints constraints;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.granteePrincipal(model.granteePrincipal);
            this.retiringPrincipal(model.retiringPrincipal);
            this.operationsWithStrings(model.operations);
            this.constraints(model.constraints);
            this.grantTokens(model.grantTokens);
            this.name(model.name);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGranteePrincipal() {
            return this.granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        public final String getRetiringPrincipal() {
            return this.retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        public final Collection<String> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operationsWithStrings(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationsWithStrings(String ... operations) {
            this.operationsWithStrings(Arrays.asList(operations));
            return this;
        }

        @Override
        public final Builder operations(Collection<GrantOperation> operations) {
            this.operations = GrantOperationListCopier.copyEnumToString(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(GrantOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
        }

        public final GrantConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        @Override
        public final Builder constraints(GrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(GrantConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGrantRequest build() {
            return new CreateGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGrantRequest> {
        public Builder keyId(String var1);

        public Builder granteePrincipal(String var1);

        public Builder retiringPrincipal(String var1);

        public Builder operationsWithStrings(Collection<String> var1);

        public Builder operationsWithStrings(String ... var1);

        public Builder operations(Collection<GrantOperation> var1);

        public Builder operations(GrantOperation ... var1);

        public Builder constraints(GrantConstraints var1);

        default public Builder constraints(Consumer<GrantConstraints.Builder> constraints) {
            return this.constraints((GrantConstraints)((GrantConstraints.Builder)GrantConstraints.builder().applyMutation(constraints)).build());
        }

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

