/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.AlreadyExistsException;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterInUseException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotActiveException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotFoundException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotRelatedException;
import software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.CreateAliasRequest;
import software.amazon.awssdk.services.kms.model.CreateAliasResponse;
import software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.CreateGrantRequest;
import software.amazon.awssdk.services.kms.model.CreateGrantResponse;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;
import software.amazon.awssdk.services.kms.model.CreateKeyResponse;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreHasCmKsException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreInvalidStateException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreNameInUseException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreNotFoundException;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DeleteAliasRequest;
import software.amazon.awssdk.services.kms.model.DeleteAliasResponse;
import software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.DependencyTimeoutException;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.DisabledException;
import software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.EnableKeyRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyResponse;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.ExpiredImportTokenException;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateRandomRequest;
import software.amazon.awssdk.services.kms.model.GenerateRandomResponse;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse;
import software.amazon.awssdk.services.kms.model.GetParametersForImportRequest;
import software.amazon.awssdk.services.kms.model.GetParametersForImportResponse;
import software.amazon.awssdk.services.kms.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.kms.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.IncorrectKeyException;
import software.amazon.awssdk.services.kms.model.IncorrectKeyMaterialException;
import software.amazon.awssdk.services.kms.model.IncorrectTrustAnchorException;
import software.amazon.awssdk.services.kms.model.InvalidAliasNameException;
import software.amazon.awssdk.services.kms.model.InvalidArnException;
import software.amazon.awssdk.services.kms.model.InvalidCiphertextException;
import software.amazon.awssdk.services.kms.model.InvalidGrantIdException;
import software.amazon.awssdk.services.kms.model.InvalidGrantTokenException;
import software.amazon.awssdk.services.kms.model.InvalidImportTokenException;
import software.amazon.awssdk.services.kms.model.InvalidKeyUsageException;
import software.amazon.awssdk.services.kms.model.InvalidMarkerException;
import software.amazon.awssdk.services.kms.model.KeyUnavailableException;
import software.amazon.awssdk.services.kms.model.KmsException;
import software.amazon.awssdk.services.kms.model.KmsInternalException;
import software.amazon.awssdk.services.kms.model.KmsInvalidSignatureException;
import software.amazon.awssdk.services.kms.model.KmsInvalidStateException;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.LimitExceededException;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;
import software.amazon.awssdk.services.kms.model.ListResourceTagsRequest;
import software.amazon.awssdk.services.kms.model.ListResourceTagsResponse;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse;
import software.amazon.awssdk.services.kms.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.kms.model.NotFoundException;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.ReEncryptRequest;
import software.amazon.awssdk.services.kms.model.ReEncryptResponse;
import software.amazon.awssdk.services.kms.model.RetireGrantRequest;
import software.amazon.awssdk.services.kms.model.RetireGrantResponse;
import software.amazon.awssdk.services.kms.model.RevokeGrantRequest;
import software.amazon.awssdk.services.kms.model.RevokeGrantResponse;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.SignRequest;
import software.amazon.awssdk.services.kms.model.SignResponse;
import software.amazon.awssdk.services.kms.model.TagException;
import software.amazon.awssdk.services.kms.model.TagResourceRequest;
import software.amazon.awssdk.services.kms.model.TagResourceResponse;
import software.amazon.awssdk.services.kms.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kms.model.UntagResourceRequest;
import software.amazon.awssdk.services.kms.model.UntagResourceResponse;
import software.amazon.awssdk.services.kms.model.UpdateAliasRequest;
import software.amazon.awssdk.services.kms.model.UpdateAliasResponse;
import software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionResponse;
import software.amazon.awssdk.services.kms.model.VerifyRequest;
import software.amazon.awssdk.services.kms.model.VerifyResponse;
import software.amazon.awssdk.services.kms.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.kms.paginators.ListGrantsIterable;
import software.amazon.awssdk.services.kms.paginators.ListKeyPoliciesIterable;
import software.amazon.awssdk.services.kms.paginators.ListKeysIterable;
import software.amazon.awssdk.services.kms.transform.CancelKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ConnectCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DecryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteImportedKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeCustomKeyStoresRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisconnectCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyPairRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyPairWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateRandomRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyRotationStatusRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetParametersForImportRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ImportKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeysRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListResourceTagsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListRetirableGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ReEncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RetireGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RevokeGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ScheduleKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.SignRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateKeyDescriptionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.VerifyRequestMarshaller;

@SdkInternalApi
final class DefaultKmsClient
implements KmsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKmsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelKeyDeletionResponse cancelKeyDeletion(CancelKeyDeletionRequest cancelKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelKeyDeletionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelKeyDeletion");
            CancelKeyDeletionResponse cancelKeyDeletionResponse = (CancelKeyDeletionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelKeyDeletion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelKeyDeletionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CancelKeyDeletionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelKeyDeletionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, cancelKeyDeletionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectCustomKeyStoreResponse connectCustomKeyStore(ConnectCustomKeyStoreRequest connectCustomKeyStoreRequest) throws CloudHsmClusterNotActiveException, CustomKeyStoreInvalidStateException, CustomKeyStoreNotFoundException, KmsInternalException, CloudHsmClusterInvalidConfigurationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConnectCustomKeyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConnectCustomKeyStore");
            ConnectCustomKeyStoreResponse connectCustomKeyStoreResponse = (ConnectCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConnectCustomKeyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)connectCustomKeyStoreRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ConnectCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return connectCustomKeyStoreResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, connectCustomKeyStoreRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws DependencyTimeoutException, AlreadyExistsException, NotFoundException, InvalidAliasNameException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            CreateAliasResponse createAliasResponse = (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomKeyStoreResponse createCustomKeyStore(CreateCustomKeyStoreRequest createCustomKeyStoreRequest) throws CloudHsmClusterInUseException, CustomKeyStoreNameInUseException, CloudHsmClusterNotFoundException, KmsInternalException, CloudHsmClusterNotActiveException, IncorrectTrustAnchorException, CloudHsmClusterInvalidConfigurationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomKeyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomKeyStore");
            CreateCustomKeyStoreResponse createCustomKeyStoreResponse = (CreateCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomKeyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomKeyStoreRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomKeyStoreResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, createCustomKeyStoreRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGrantResponse createGrant(CreateGrantRequest createGrantRequest) throws NotFoundException, DisabledException, DependencyTimeoutException, InvalidArnException, KmsInternalException, InvalidGrantTokenException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGrant");
            CreateGrantResponse createGrantResponse = (CreateGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGrantRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGrantResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, createGrantRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKeyResponse createKey(CreateKeyRequest createKeyRequest) throws MalformedPolicyDocumentException, DependencyTimeoutException, InvalidArnException, UnsupportedOperationException, KmsInternalException, LimitExceededException, TagException, CustomKeyStoreNotFoundException, CustomKeyStoreInvalidStateException, CloudHsmClusterInvalidConfigurationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKey");
            CreateKeyResponse createKeyResponse = (CreateKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, createKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecryptResponse decrypt(DecryptRequest decryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, IncorrectKeyException, InvalidKeyUsageException, DependencyTimeoutException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecryptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Decrypt");
            DecryptResponse decryptResponse = (DecryptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Decrypt").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)decryptRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DecryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return decryptResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, decryptRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlias");
            DeleteAliasResponse deleteAliasResponse = (DeleteAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, deleteAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomKeyStoreResponse deleteCustomKeyStore(DeleteCustomKeyStoreRequest deleteCustomKeyStoreRequest) throws CustomKeyStoreHasCmKsException, CustomKeyStoreInvalidStateException, CustomKeyStoreNotFoundException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomKeyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomKeyStore");
            DeleteCustomKeyStoreResponse deleteCustomKeyStoreResponse = (DeleteCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomKeyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomKeyStoreRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomKeyStoreResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomKeyStoreRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteImportedKeyMaterialResponse deleteImportedKeyMaterial(DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteImportedKeyMaterialResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteImportedKeyMaterial");
            DeleteImportedKeyMaterialResponse deleteImportedKeyMaterialResponse = (DeleteImportedKeyMaterialResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteImportedKeyMaterial").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteImportedKeyMaterialRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteImportedKeyMaterialRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteImportedKeyMaterialResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, deleteImportedKeyMaterialRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomKeyStoresResponse describeCustomKeyStores(DescribeCustomKeyStoresRequest describeCustomKeyStoresRequest) throws CustomKeyStoreNotFoundException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomKeyStoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomKeyStores");
            DescribeCustomKeyStoresResponse describeCustomKeyStoresResponse = (DescribeCustomKeyStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomKeyStores").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCustomKeyStoresRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomKeyStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomKeyStoresResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, describeCustomKeyStoresRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeKeyResponse describeKey(DescribeKeyRequest describeKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKey");
            DescribeKeyResponse describeKeyResponse = (DescribeKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, describeKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableKeyResponse disableKey(DisableKeyRequest disableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKey");
            DisableKeyResponse disableKeyResponse = (DisableKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisableKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, disableKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableKeyRotationResponse disableKeyRotation(DisableKeyRotationRequest disableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKeyRotationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKeyRotation");
            DisableKeyRotationResponse disableKeyRotationResponse = (DisableKeyRotationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKeyRotation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableKeyRotationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisableKeyRotationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableKeyRotationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, disableKeyRotationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisconnectCustomKeyStoreResponse disconnectCustomKeyStore(DisconnectCustomKeyStoreRequest disconnectCustomKeyStoreRequest) throws CustomKeyStoreInvalidStateException, CustomKeyStoreNotFoundException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectCustomKeyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectCustomKeyStore");
            DisconnectCustomKeyStoreResponse disconnectCustomKeyStoreResponse = (DisconnectCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectCustomKeyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disconnectCustomKeyStoreRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisconnectCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disconnectCustomKeyStoreResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, disconnectCustomKeyStoreRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableKeyResponse enableKey(EnableKeyRequest enableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKey");
            EnableKeyResponse enableKeyResponse = (EnableKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnableKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, enableKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableKeyRotationResponse enableKeyRotation(EnableKeyRotationRequest enableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKeyRotationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKeyRotation");
            EnableKeyRotationResponse enableKeyRotationResponse = (EnableKeyRotationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKeyRotation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableKeyRotationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EnableKeyRotationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableKeyRotationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, enableKeyRotationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptResponse encrypt(EncryptRequest encryptRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EncryptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Encrypt");
            EncryptResponse encryptResponse = (EncryptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Encrypt").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)encryptRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new EncryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return encryptResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, encryptRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKey");
            GenerateDataKeyResponse generateDataKeyResponse = (GenerateDataKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateDataKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, generateDataKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyPairResponse generateDataKeyPair(GenerateDataKeyPairRequest generateDataKeyPairRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyPairResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyPair");
            GenerateDataKeyPairResponse generateDataKeyPairResponse = (GenerateDataKeyPairResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyPair").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateDataKeyPairRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyPairResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, generateDataKeyPairRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyPairWithoutPlaintextResponse generateDataKeyPairWithoutPlaintext(GenerateDataKeyPairWithoutPlaintextRequest generateDataKeyPairWithoutPlaintextRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyPairWithoutPlaintextResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyPairWithoutPlaintext");
            GenerateDataKeyPairWithoutPlaintextResponse generateDataKeyPairWithoutPlaintextResponse = (GenerateDataKeyPairWithoutPlaintextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyPairWithoutPlaintext").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateDataKeyPairWithoutPlaintextRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyPairWithoutPlaintextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyPairWithoutPlaintextResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, generateDataKeyPairWithoutPlaintextRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintext(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyWithoutPlaintextResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyWithoutPlaintext");
            GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintextResponse = (GenerateDataKeyWithoutPlaintextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyWithoutPlaintext").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateDataKeyWithoutPlaintextRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyWithoutPlaintextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyWithoutPlaintextResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, generateDataKeyWithoutPlaintextRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateRandomResponse generateRandom(GenerateRandomRequest generateRandomRequest) throws DependencyTimeoutException, KmsInternalException, CustomKeyStoreNotFoundException, CustomKeyStoreInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateRandomResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateRandom");
            GenerateRandomResponse generateRandomResponse = (GenerateRandomResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateRandom").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)generateRandomRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GenerateRandomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateRandomResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, generateRandomRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyPolicyResponse getKeyPolicy(GetKeyPolicyRequest getKeyPolicyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPolicy");
            GetKeyPolicyResponse getKeyPolicyResponse = (GetKeyPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKeyPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetKeyPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKeyPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, getKeyPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyRotationStatusResponse getKeyRotationStatus(GetKeyRotationStatusRequest getKeyRotationStatusRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyRotationStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyRotationStatus");
            GetKeyRotationStatusResponse getKeyRotationStatusResponse = (GetKeyRotationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyRotationStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getKeyRotationStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetKeyRotationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKeyRotationStatusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, getKeyRotationStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetParametersForImportResponse getParametersForImport(GetParametersForImportRequest getParametersForImportRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetParametersForImportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetParametersForImport");
            GetParametersForImportResponse getParametersForImportResponse = (GetParametersForImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetParametersForImport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getParametersForImportRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetParametersForImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getParametersForImportResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, getParametersForImportRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, UnsupportedOperationException, InvalidArnException, InvalidGrantTokenException, InvalidKeyUsageException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPublicKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKey");
            GetPublicKeyResponse getPublicKeyResponse = (GetPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPublicKeyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPublicKeyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, getPublicKeyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportKeyMaterialResponse importKeyMaterial(ImportKeyMaterialRequest importKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, InvalidCiphertextException, IncorrectKeyMaterialException, ExpiredImportTokenException, InvalidImportTokenException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportKeyMaterialResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportKeyMaterial");
            ImportKeyMaterialResponse importKeyMaterialResponse = (ImportKeyMaterialResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportKeyMaterial").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importKeyMaterialRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ImportKeyMaterialRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importKeyMaterialResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, importKeyMaterialRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws DependencyTimeoutException, InvalidMarkerException, KmsInternalException, InvalidArnException, NotFoundException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAliases");
            ListAliasesResponse listAliasesResponse = (ListAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAliasesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAliasesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, listAliasesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws DependencyTimeoutException, InvalidMarkerException, KmsInternalException, InvalidArnException, NotFoundException, AwsServiceException, SdkClientException, KmsException {
        return new ListAliasesIterable(this, this.applyPaginatorUserAgent(listAliasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGrantsResponse listGrants(ListGrantsRequest listGrantsRequest) throws NotFoundException, DependencyTimeoutException, InvalidMarkerException, InvalidArnException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGrantsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGrants");
            ListGrantsResponse listGrantsResponse = (ListGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGrants").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGrantsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGrantsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, listGrantsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListGrantsIterable listGrantsPaginator(ListGrantsRequest listGrantsRequest) throws NotFoundException, DependencyTimeoutException, InvalidMarkerException, InvalidArnException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        return new ListGrantsIterable(this, this.applyPaginatorUserAgent(listGrantsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyPoliciesResponse listKeyPolicies(ListKeyPoliciesRequest listKeyPoliciesRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyPoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyPolicies");
            ListKeyPoliciesResponse listKeyPoliciesResponse = (ListKeyPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKeyPoliciesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListKeyPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeyPoliciesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, listKeyPoliciesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListKeyPoliciesIterable listKeyPoliciesPaginator(ListKeyPoliciesRequest listKeyPoliciesRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        return new ListKeyPoliciesIterable(this, this.applyPaginatorUserAgent(listKeyPoliciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeysResponse listKeys(ListKeysRequest listKeysRequest) throws DependencyTimeoutException, KmsInternalException, InvalidMarkerException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeys");
            ListKeysResponse listKeysResponse = (ListKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeys").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKeysRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeysResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, listKeysRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListKeysIterable listKeysPaginator(ListKeysRequest listKeysRequest) throws DependencyTimeoutException, KmsInternalException, InvalidMarkerException, AwsServiceException, SdkClientException, KmsException {
        return new ListKeysIterable(this, this.applyPaginatorUserAgent(listKeysRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceTagsResponse listResourceTags(ListResourceTagsRequest listResourceTagsRequest) throws KmsInternalException, NotFoundException, InvalidArnException, InvalidMarkerException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTags");
            ListResourceTagsResponse listResourceTagsResponse = (ListResourceTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, listResourceTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRetirableGrantsResponse listRetirableGrants(ListRetirableGrantsRequest listRetirableGrantsRequest) throws DependencyTimeoutException, InvalidMarkerException, InvalidArnException, NotFoundException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRetirableGrantsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRetirableGrants");
            ListRetirableGrantsResponse listRetirableGrantsResponse = (ListRetirableGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRetirableGrants").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRetirableGrantsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListRetirableGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRetirableGrantsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, listRetirableGrantsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutKeyPolicyResponse putKeyPolicy(PutKeyPolicyRequest putKeyPolicyRequest) throws NotFoundException, InvalidArnException, MalformedPolicyDocumentException, DependencyTimeoutException, UnsupportedOperationException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutKeyPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutKeyPolicy");
            PutKeyPolicyResponse putKeyPolicyResponse = (PutKeyPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutKeyPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putKeyPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutKeyPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putKeyPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, putKeyPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReEncryptResponse reEncrypt(ReEncryptRequest reEncryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, IncorrectKeyException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReEncryptResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReEncrypt");
            ReEncryptResponse reEncryptResponse = (ReEncryptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReEncrypt").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reEncryptRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ReEncryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return reEncryptResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, reEncryptRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetireGrantResponse retireGrant(RetireGrantRequest retireGrantRequest) throws InvalidArnException, InvalidGrantTokenException, InvalidGrantIdException, NotFoundException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetireGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetireGrant");
            RetireGrantResponse retireGrantResponse = (RetireGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetireGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)retireGrantRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RetireGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retireGrantResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, retireGrantRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeGrantResponse revokeGrant(RevokeGrantRequest revokeGrantRequest) throws NotFoundException, DependencyTimeoutException, InvalidArnException, InvalidGrantIdException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeGrantResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeGrant");
            RevokeGrantResponse revokeGrantResponse = (RevokeGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeGrant").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeGrantRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RevokeGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeGrantResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, revokeGrantRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ScheduleKeyDeletionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ScheduleKeyDeletion");
            ScheduleKeyDeletionResponse scheduleKeyDeletionResponse = (ScheduleKeyDeletionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ScheduleKeyDeletion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)scheduleKeyDeletionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ScheduleKeyDeletionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return scheduleKeyDeletionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, scheduleKeyDeletionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignResponse sign(SignRequest signRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Sign");
            SignResponse signResponse = (SignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Sign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)signRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return signResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, signRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws KmsInternalException, NotFoundException, InvalidArnException, KmsInvalidStateException, LimitExceededException, TagException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws KmsInternalException, NotFoundException, InvalidArnException, KmsInvalidStateException, TagException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws DependencyTimeoutException, NotFoundException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAlias");
            UpdateAliasResponse updateAliasResponse = (UpdateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAliasRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAliasResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, updateAliasRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomKeyStoreResponse updateCustomKeyStore(UpdateCustomKeyStoreRequest updateCustomKeyStoreRequest) throws CustomKeyStoreNotFoundException, CustomKeyStoreNameInUseException, CloudHsmClusterNotFoundException, CloudHsmClusterNotRelatedException, CustomKeyStoreInvalidStateException, KmsInternalException, CloudHsmClusterNotActiveException, CloudHsmClusterInvalidConfigurationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomKeyStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomKeyStore");
            UpdateCustomKeyStoreResponse updateCustomKeyStoreResponse = (UpdateCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomKeyStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCustomKeyStoreRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCustomKeyStoreResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, updateCustomKeyStoreRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKeyDescriptionResponse updateKeyDescription(UpdateKeyDescriptionRequest updateKeyDescriptionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKeyDescriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKeyDescription");
            UpdateKeyDescriptionResponse updateKeyDescriptionResponse = (UpdateKeyDescriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKeyDescription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateKeyDescriptionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKeyDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKeyDescriptionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, updateKeyDescriptionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyResponse verify(VerifyRequest verifyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, KmsInvalidSignatureException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Verify");
            VerifyResponse verifyResponse = (VerifyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Verify").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)verifyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new VerifyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(this.clientConfiguration, verifyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KmsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").exceptionBuilderSupplier(ExpiredImportTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").exceptionBuilderSupplier(InvalidImportTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").exceptionBuilderSupplier(KmsInvalidStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArnException").exceptionBuilderSupplier(InvalidArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DisabledException").exceptionBuilderSupplier(DisabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KeyUnavailableException").exceptionBuilderSupplier(KeyUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInternalException").exceptionBuilderSupplier(KmsInternalException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").exceptionBuilderSupplier(InvalidCiphertextException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").exceptionBuilderSupplier(InvalidGrantIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncorrectKeyException").exceptionBuilderSupplier(IncorrectKeyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").exceptionBuilderSupplier(InvalidGrantTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagException").exceptionBuilderSupplier(TagException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").exceptionBuilderSupplier(InvalidKeyUsageException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMarkerException").exceptionBuilderSupplier(InvalidMarkerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").exceptionBuilderSupplier(InvalidAliasNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").exceptionBuilderSupplier(DependencyTimeoutException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends KmsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.57").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((KmsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

