/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.kms.model.DataKeySpec;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateDataKeyRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, GenerateDataKeyRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::keyId)).setter(GenerateDataKeyRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Map<String, String>> ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::encryptionContext)).setter(GenerateDataKeyRequest.setter(Builder::encryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::numberOfBytes)).setter(GenerateDataKeyRequest.setter(Builder::numberOfBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytes").build()}).build();
    private static final SdkField<String> KEY_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::keySpecAsString)).setter(GenerateDataKeyRequest.setter(Builder::keySpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySpec").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::grantTokens)).setter(GenerateDataKeyRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, ENCRYPTION_CONTEXT_FIELD, NUMBER_OF_BYTES_FIELD, KEY_SPEC_FIELD, GRANT_TOKENS_FIELD));
    private final String keyId;
    private final Map<String, String> encryptionContext;
    private final Integer numberOfBytes;
    private final String keySpec;
    private final List<String> grantTokens;

    private GenerateDataKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.encryptionContext = builder.encryptionContext;
        this.numberOfBytes = builder.numberOfBytes;
        this.keySpec = builder.keySpec;
        this.grantTokens = builder.grantTokens;
    }

    public String keyId() {
        return this.keyId;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Integer numberOfBytes() {
        return this.numberOfBytes;
    }

    public DataKeySpec keySpec() {
        return DataKeySpec.fromValue(this.keySpec);
    }

    public String keySpecAsString() {
        return this.keySpec;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyRequest)) {
            return false;
        }
        GenerateDataKeyRequest other = (GenerateDataKeyRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.encryptionContext(), other.encryptionContext()) && Objects.equals(this.numberOfBytes(), other.numberOfBytes()) && Objects.equals(this.keySpecAsString(), other.keySpecAsString()) && Objects.equals(this.grantTokens(), other.grantTokens());
    }

    public String toString() {
        return ToString.builder((String)"GenerateDataKeyRequest").add("KeyId", (Object)this.keyId()).add("EncryptionContext", this.encryptionContext()).add("NumberOfBytes", (Object)this.numberOfBytes()).add("KeySpec", (Object)this.keySpecAsString()).add("GrantTokens", this.grantTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "EncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.encryptionContext()));
            }
            case "NumberOfBytes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBytes()));
            }
            case "KeySpec": {
                return Optional.ofNullable(clazz.cast(this.keySpecAsString()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateDataKeyRequest, T> g) {
        return obj -> g.apply((GenerateDataKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private Map<String, String> encryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private Integer numberOfBytes;
        private String keySpec;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.encryptionContext(model.encryptionContext);
            this.numberOfBytes(model.numberOfBytes);
            this.keySpec(model.keySpec);
            this.grantTokens(model.grantTokens);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final Integer getNumberOfBytes() {
            return this.numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        public final String getKeySpecAsString() {
            return this.keySpec;
        }

        @Override
        public final Builder keySpec(String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        @Override
        public final Builder keySpec(DataKeySpec keySpec) {
            this.keySpec(keySpec == null ? null : keySpec.toString());
            return this;
        }

        public final void setKeySpec(String keySpec) {
            this.keySpec = keySpec;
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateDataKeyRequest build() {
            return new GenerateDataKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateDataKeyRequest> {
        public Builder keyId(String var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder numberOfBytes(Integer var1);

        public Builder keySpec(String var1);

        public Builder keySpec(DataKeySpec var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

