/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.kms.KMSAsyncClient;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;

public class ListKeysPublisher
implements SdkPublisher<ListKeysResponse> {
    private final KMSAsyncClient client;
    private final ListKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeysPublisher(KMSAsyncClient client, ListKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeysPublisher(KMSAsyncClient client, ListKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<KeyListEntry> keys() {
        Function<ListKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.keys() != null) {
                return response.keys().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListKeysResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListKeysPublisher resume(ListKeysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListKeysPublisher(this.client, (ListKeysRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListKeysPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListKeysResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListKeysResponseFetcher
    implements AsyncPageFetcher<ListKeysResponse> {
        private ListKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListKeysResponse previousPage) {
            return previousPage.truncated();
        }

        public CompletableFuture<ListKeysResponse> nextPage(ListKeysResponse previousPage) {
            if (previousPage == null) {
                return ListKeysPublisher.this.client.listKeys(ListKeysPublisher.this.firstRequest);
            }
            return ListKeysPublisher.this.client.listKeys((ListKeysRequest)((Object)ListKeysPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

