/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.kms.KMSAsyncClient;
import software.amazon.awssdk.services.kms.model.AliasListEntry;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;

public class ListAliasesPublisher
implements SdkPublisher<ListAliasesResponse> {
    private final KMSAsyncClient client;
    private final ListAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAliasesPublisher(KMSAsyncClient client, ListAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAliasesPublisher(KMSAsyncClient client, ListAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<AliasListEntry> aliases() {
        Function<ListAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.aliases() != null) {
                return response.aliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListAliasesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListAliasesPublisher resume(ListAliasesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAliasesPublisher(this.client, (ListAliasesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListAliasesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAliasesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAliasesResponseFetcher
    implements AsyncPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return previousPage.truncated();
        }

        public CompletableFuture<ListAliasesResponse> nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesPublisher.this.client.listAliases(ListAliasesPublisher.this.firstRequest);
            }
            return ListAliasesPublisher.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

