/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest;

@SdkInternalApi
public class ImportKeyMaterialRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<ByteBuffer> IMPORTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportToken").build();
    private static final MarshallingInfo<ByteBuffer> ENCRYPTEDKEYMATERIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptedKeyMaterial").build();
    private static final MarshallingInfo<Instant> VALIDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidTo").build();
    private static final MarshallingInfo<String> EXPIRATIONMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationModel").build();
    private static final ImportKeyMaterialRequestModelMarshaller INSTANCE = new ImportKeyMaterialRequestModelMarshaller();

    public static ImportKeyMaterialRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportKeyMaterialRequest importKeyMaterialRequest, ProtocolMarshaller protocolMarshaller) {
        if (importKeyMaterialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.importToken(), IMPORTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.encryptedKeyMaterial(), ENCRYPTEDKEYMATERIAL_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.validTo(), VALIDTO_BINDING);
            protocolMarshaller.marshall((Object)importKeyMaterialRequest.expirationModelString(), EXPIRATIONMODEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

