/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;

public final class ListKeyPoliciesPaginator
implements SdkIterable<ListKeyPoliciesResponse> {
    private final KMSClient client;
    private final ListKeyPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListKeyPoliciesPaginator(KMSClient client, ListKeyPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKeyPoliciesResponseFetcher();
    }

    public Iterator<ListKeyPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> policyNames() {
        Function<ListKeyPoliciesResponse, Iterator> getIterator = response -> response != null ? response.policyNames().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListKeyPoliciesResponseFetcher
    implements NextPageFetcher<ListKeyPoliciesResponse> {
        private ListKeyPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyPoliciesResponse previousPage) {
            return previousPage.truncated();
        }

        public ListKeyPoliciesResponse nextPage(ListKeyPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListKeyPoliciesPaginator.this.client.listKeyPolicies(ListKeyPoliciesPaginator.this.firstRequest);
            }
            return ListKeyPoliciesPaginator.this.client.listKeyPolicies((ListKeyPoliciesRequest)((Object)ListKeyPoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

