/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;

public final class ListGrantsPaginator
implements SdkIterable<ListGrantsResponse> {
    private final KMSClient client;
    private final ListGrantsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListGrantsPaginator(KMSClient client, ListGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGrantsResponseFetcher();
    }

    public Iterator<ListGrantsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<GrantListEntry> grants() {
        Function<ListGrantsResponse, Iterator> getIterator = response -> response != null ? response.grants().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListGrantsResponseFetcher
    implements NextPageFetcher<ListGrantsResponse> {
        private ListGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListGrantsResponse previousPage) {
            return previousPage.truncated();
        }

        public ListGrantsResponse nextPage(ListGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListGrantsPaginator.this.client.listGrants(ListGrantsPaginator.this.firstRequest);
            }
            return ListGrantsPaginator.this.client.listGrants((ListGrantsRequest)((Object)ListGrantsPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

