/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.AliasListEntry;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;

public final class ListAliasesPaginator
implements SdkIterable<ListAliasesResponse> {
    private final KMSClient client;
    private final ListAliasesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAliasesPaginator(KMSClient client, ListAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public Iterator<ListAliasesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AliasListEntry> aliases() {
        Function<ListAliasesResponse, Iterator> getIterator = response -> response != null ? response.aliases().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListAliasesResponseFetcher
    implements NextPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return previousPage.truncated();
        }

        public ListAliasesResponse nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesPaginator.this.client.listAliases(ListAliasesPaginator.this.firstRequest);
            }
            return ListAliasesPaginator.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

