/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduleKeyDeletionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ScheduleKeyDeletionResponse> {
    private final String keyId;
    private final Instant deletionDate;

    private ScheduleKeyDeletionResponse(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.deletionDate = builder.deletionDate;
    }

    public String keyId() {
        return this.keyId;
    }

    public Instant deletionDate() {
        return this.deletionDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.deletionDate() == null ? 0 : this.deletionDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleKeyDeletionResponse)) {
            return false;
        }
        ScheduleKeyDeletionResponse other = (ScheduleKeyDeletionResponse)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.deletionDate() == null ^ this.deletionDate() == null) {
            return false;
        }
        return other.deletionDate() == null || other.deletionDate().equals(this.deletionDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.deletionDate() != null) {
            sb.append("DeletionDate: ").append(this.deletionDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "DeletionDate": {
                return Optional.of(clazz.cast(this.deletionDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private Instant deletionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleKeyDeletionResponse model) {
            this.keyId(model.keyId);
            this.deletionDate(model.deletionDate);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public ScheduleKeyDeletionResponse build() {
            return new ScheduleKeyDeletionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduleKeyDeletionResponse> {
        public Builder keyId(String var1);

        public Builder deletionDate(Instant var1);
    }
}

