/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RetireGrantRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RetireGrantRequest> {
    private final String grantToken;
    private final String keyId;
    private final String grantId;

    private RetireGrantRequest(BuilderImpl builder) {
        this.grantToken = builder.grantToken;
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
    }

    public String grantToken() {
        return this.grantToken;
    }

    public String keyId() {
        return this.keyId;
    }

    public String grantId() {
        return this.grantId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.grantToken() == null ? 0 : this.grantToken().hashCode());
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.grantId() == null ? 0 : this.grantId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetireGrantRequest)) {
            return false;
        }
        RetireGrantRequest other = (RetireGrantRequest)((Object)obj);
        if (other.grantToken() == null ^ this.grantToken() == null) {
            return false;
        }
        if (other.grantToken() != null && !other.grantToken().equals(this.grantToken())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.grantId() == null ^ this.grantId() == null) {
            return false;
        }
        return other.grantId() == null || other.grantId().equals(this.grantId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.grantToken() != null) {
            sb.append("GrantToken: ").append(this.grantToken()).append(",");
        }
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.grantId() != null) {
            sb.append("GrantId: ").append(this.grantId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrantToken": {
                return Optional.of(clazz.cast(this.grantToken()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "GrantId": {
                return Optional.of(clazz.cast(this.grantId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String grantToken;
        private String keyId;
        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetireGrantRequest model) {
            this.grantToken(model.grantToken);
            this.keyId(model.keyId);
            this.grantId(model.grantId);
        }

        public final String getGrantToken() {
            return this.grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        public RetireGrantRequest build() {
            return new RetireGrantRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RetireGrantRequest> {
        public Builder grantToken(String var1);

        public Builder keyId(String var1);

        public Builder grantId(String var1);
    }
}

