/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReEncryptRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReEncryptRequest> {
    private final ByteBuffer ciphertextBlob;
    private final Map<String, String> sourceEncryptionContext;
    private final String destinationKeyId;
    private final Map<String, String> destinationEncryptionContext;
    private final List<String> grantTokens;

    private ReEncryptRequest(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.sourceEncryptionContext = builder.sourceEncryptionContext;
        this.destinationKeyId = builder.destinationKeyId;
        this.destinationEncryptionContext = builder.destinationEncryptionContext;
        this.grantTokens = builder.grantTokens;
    }

    public ByteBuffer ciphertextBlob() {
        return this.ciphertextBlob == null ? null : this.ciphertextBlob.asReadOnlyBuffer();
    }

    public Map<String, String> sourceEncryptionContext() {
        return this.sourceEncryptionContext;
    }

    public String destinationKeyId() {
        return this.destinationKeyId;
    }

    public Map<String, String> destinationEncryptionContext() {
        return this.destinationEncryptionContext;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ciphertextBlob() == null ? 0 : this.ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + (this.sourceEncryptionContext() == null ? 0 : this.sourceEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.destinationKeyId() == null ? 0 : this.destinationKeyId().hashCode());
        hashCode = 31 * hashCode + (this.destinationEncryptionContext() == null ? 0 : this.destinationEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.grantTokens() == null ? 0 : this.grantTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptRequest)) {
            return false;
        }
        ReEncryptRequest other = (ReEncryptRequest)((Object)obj);
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.sourceEncryptionContext() == null ^ this.sourceEncryptionContext() == null) {
            return false;
        }
        if (other.sourceEncryptionContext() != null && !other.sourceEncryptionContext().equals(this.sourceEncryptionContext())) {
            return false;
        }
        if (other.destinationKeyId() == null ^ this.destinationKeyId() == null) {
            return false;
        }
        if (other.destinationKeyId() != null && !other.destinationKeyId().equals(this.destinationKeyId())) {
            return false;
        }
        if (other.destinationEncryptionContext() == null ^ this.destinationEncryptionContext() == null) {
            return false;
        }
        if (other.destinationEncryptionContext() != null && !other.destinationEncryptionContext().equals(this.destinationEncryptionContext())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        return other.grantTokens() == null || other.grantTokens().equals(this.grantTokens());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(this.ciphertextBlob()).append(",");
        }
        if (this.sourceEncryptionContext() != null) {
            sb.append("SourceEncryptionContext: ").append(this.sourceEncryptionContext()).append(",");
        }
        if (this.destinationKeyId() != null) {
            sb.append("DestinationKeyId: ").append(this.destinationKeyId()).append(",");
        }
        if (this.destinationEncryptionContext() != null) {
            sb.append("DestinationEncryptionContext: ").append(this.destinationEncryptionContext()).append(",");
        }
        if (this.grantTokens() != null) {
            sb.append("GrantTokens: ").append(this.grantTokens()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.of(clazz.cast(this.ciphertextBlob()));
            }
            case "SourceEncryptionContext": {
                return Optional.of(clazz.cast(this.sourceEncryptionContext()));
            }
            case "DestinationKeyId": {
                return Optional.of(clazz.cast(this.destinationKeyId()));
            }
            case "DestinationEncryptionContext": {
                return Optional.of(clazz.cast(this.destinationEncryptionContext()));
            }
            case "GrantTokens": {
                return Optional.of(clazz.cast(this.grantTokens()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ByteBuffer ciphertextBlob;
        private Map<String, String> sourceEncryptionContext;
        private String destinationKeyId;
        private Map<String, String> destinationEncryptionContext;
        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptRequest model) {
            this.ciphertextBlob(model.ciphertextBlob);
            this.sourceEncryptionContext(model.sourceEncryptionContext);
            this.destinationKeyId(model.destinationKeyId);
            this.destinationEncryptionContext(model.destinationEncryptionContext);
            this.grantTokens(model.grantTokens);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
        }

        public final Map<String, String> getSourceEncryptionContext() {
            return this.sourceEncryptionContext;
        }

        @Override
        public final Builder sourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
            return this;
        }

        public final void setSourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
        }

        public final String getDestinationKeyId() {
            return this.destinationKeyId;
        }

        @Override
        public final Builder destinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
            return this;
        }

        public final void setDestinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
        }

        public final Map<String, String> getDestinationEncryptionContext() {
            return this.destinationEncryptionContext;
        }

        @Override
        public final Builder destinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
            return this;
        }

        public final void setDestinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        public ReEncryptRequest build() {
            return new ReEncryptRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReEncryptRequest> {
        public Builder ciphertextBlob(ByteBuffer var1);

        public Builder sourceEncryptionContext(Map<String, String> var1);

        public Builder destinationKeyId(String var1);

        public Builder destinationEncryptionContext(Map<String, String> var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);
    }
}

