/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutKeyPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutKeyPolicyRequest> {
    private final String keyId;
    private final String policyName;
    private final String policy;
    private final Boolean bypassPolicyLockoutSafetyCheck;

    private PutKeyPolicyRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.policyName = builder.policyName;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
    }

    public String keyId() {
        return this.keyId;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policy() {
        return this.policy;
    }

    public Boolean bypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policy() == null ? 0 : this.policy().hashCode());
        hashCode = 31 * hashCode + (this.bypassPolicyLockoutSafetyCheck() == null ? 0 : this.bypassPolicyLockoutSafetyCheck().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutKeyPolicyRequest)) {
            return false;
        }
        PutKeyPolicyRequest other = (PutKeyPolicyRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.bypassPolicyLockoutSafetyCheck() == null ^ this.bypassPolicyLockoutSafetyCheck() == null) {
            return false;
        }
        return other.bypassPolicyLockoutSafetyCheck() == null || other.bypassPolicyLockoutSafetyCheck().equals(this.bypassPolicyLockoutSafetyCheck());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policy() != null) {
            sb.append("Policy: ").append(this.policy()).append(",");
        }
        if (this.bypassPolicyLockoutSafetyCheck() != null) {
            sb.append("BypassPolicyLockoutSafetyCheck: ").append(this.bypassPolicyLockoutSafetyCheck()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
            case "BypassPolicyLockoutSafetyCheck": {
                return Optional.of(clazz.cast(this.bypassPolicyLockoutSafetyCheck()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String policyName;
        private String policy;
        private Boolean bypassPolicyLockoutSafetyCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(PutKeyPolicyRequest model) {
            this.keyId(model.keyId);
            this.policyName(model.policyName);
            this.policy(model.policy);
            this.bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        public PutKeyPolicyRequest build() {
            return new PutKeyPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutKeyPolicyRequest> {
        public Builder keyId(String var1);

        public Builder policyName(String var1);

        public Builder policy(String var1);

        public Builder bypassPolicyLockoutSafetyCheck(Boolean var1);
    }
}

