/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.kms.model.GrantConstraints;
import software.amazon.awssdk.services.kms.model.GrantOperation;
import software.amazon.awssdk.services.kms.model.GrantOperationListCopier;
import software.amazon.awssdk.services.kms.transform.GrantListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GrantListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, GrantListEntry> {
    private final String keyId;
    private final String grantId;
    private final String name;
    private final Instant creationDate;
    private final String granteePrincipal;
    private final String retiringPrincipal;
    private final String issuingAccount;
    private final List<String> operations;
    private final GrantConstraints constraints;

    private GrantListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
        this.name = builder.name;
        this.creationDate = builder.creationDate;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.issuingAccount = builder.issuingAccount;
        this.operations = builder.operations;
        this.constraints = builder.constraints;
    }

    public String keyId() {
        return this.keyId;
    }

    public String grantId() {
        return this.grantId;
    }

    public String name() {
        return this.name;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String granteePrincipal() {
        return this.granteePrincipal;
    }

    public String retiringPrincipal() {
        return this.retiringPrincipal;
    }

    public String issuingAccount() {
        return this.issuingAccount;
    }

    public List<GrantOperation> operations() {
        return TypeConverter.convert(this.operations, GrantOperation::fromValue);
    }

    public List<String> operationsStrings() {
        return this.operations;
    }

    public GrantConstraints constraints() {
        return this.constraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.grantId() == null ? 0 : this.grantId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.granteePrincipal() == null ? 0 : this.granteePrincipal().hashCode());
        hashCode = 31 * hashCode + (this.retiringPrincipal() == null ? 0 : this.retiringPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.issuingAccount() == null ? 0 : this.issuingAccount().hashCode());
        hashCode = 31 * hashCode + (this.operationsStrings() == null ? 0 : this.operationsStrings().hashCode());
        hashCode = 31 * hashCode + (this.constraints() == null ? 0 : this.constraints().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantListEntry)) {
            return false;
        }
        GrantListEntry other = (GrantListEntry)obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.grantId() == null ^ this.grantId() == null) {
            return false;
        }
        if (other.grantId() != null && !other.grantId().equals(this.grantId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.granteePrincipal() == null ^ this.granteePrincipal() == null) {
            return false;
        }
        if (other.granteePrincipal() != null && !other.granteePrincipal().equals(this.granteePrincipal())) {
            return false;
        }
        if (other.retiringPrincipal() == null ^ this.retiringPrincipal() == null) {
            return false;
        }
        if (other.retiringPrincipal() != null && !other.retiringPrincipal().equals(this.retiringPrincipal())) {
            return false;
        }
        if (other.issuingAccount() == null ^ this.issuingAccount() == null) {
            return false;
        }
        if (other.issuingAccount() != null && !other.issuingAccount().equals(this.issuingAccount())) {
            return false;
        }
        if (other.operationsStrings() == null ^ this.operationsStrings() == null) {
            return false;
        }
        if (other.operationsStrings() != null && !other.operationsStrings().equals(this.operationsStrings())) {
            return false;
        }
        if (other.constraints() == null ^ this.constraints() == null) {
            return false;
        }
        return other.constraints() == null || other.constraints().equals(this.constraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.grantId() != null) {
            sb.append("GrantId: ").append(this.grantId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.granteePrincipal() != null) {
            sb.append("GranteePrincipal: ").append(this.granteePrincipal()).append(",");
        }
        if (this.retiringPrincipal() != null) {
            sb.append("RetiringPrincipal: ").append(this.retiringPrincipal()).append(",");
        }
        if (this.issuingAccount() != null) {
            sb.append("IssuingAccount: ").append(this.issuingAccount()).append(",");
        }
        if (this.operationsStrings() != null) {
            sb.append("Operations: ").append(this.operationsStrings()).append(",");
        }
        if (this.constraints() != null) {
            sb.append("Constraints: ").append(this.constraints()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "GrantId": {
                return Optional.of(clazz.cast(this.grantId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "GranteePrincipal": {
                return Optional.of(clazz.cast(this.granteePrincipal()));
            }
            case "RetiringPrincipal": {
                return Optional.of(clazz.cast(this.retiringPrincipal()));
            }
            case "IssuingAccount": {
                return Optional.of(clazz.cast(this.issuingAccount()));
            }
            case "Operations": {
                return Optional.of(clazz.cast(this.operationsStrings()));
            }
            case "Constraints": {
                return Optional.of(clazz.cast(this.constraints()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrantListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String grantId;
        private String name;
        private Instant creationDate;
        private String granteePrincipal;
        private String retiringPrincipal;
        private String issuingAccount;
        private List<String> operations;
        private GrantConstraints constraints;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantListEntry model) {
            this.keyId(model.keyId);
            this.grantId(model.grantId);
            this.name(model.name);
            this.creationDate(model.creationDate);
            this.granteePrincipal(model.granteePrincipal);
            this.retiringPrincipal(model.retiringPrincipal);
            this.issuingAccount(model.issuingAccount);
            this.operations(model.operations);
            this.constraints(model.constraints);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getGranteePrincipal() {
            return this.granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        public final String getRetiringPrincipal() {
            return this.retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        public final String getIssuingAccount() {
            return this.issuingAccount;
        }

        @Override
        public final Builder issuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
            return this;
        }

        public final void setIssuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
        }

        public final Collection<String> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = GrantOperationListCopier.copy(operations);
        }

        public final GrantConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        @Override
        public final Builder constraints(GrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(GrantConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        public GrantListEntry build() {
            return new GrantListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GrantListEntry> {
        public Builder keyId(String var1);

        public Builder grantId(String var1);

        public Builder name(String var1);

        public Builder creationDate(Instant var1);

        public Builder granteePrincipal(String var1);

        public Builder retiringPrincipal(String var1);

        public Builder issuingAccount(String var1);

        public Builder operations(Collection<String> var1);

        public Builder operations(String ... var1);

        public Builder constraints(GrantConstraints var1);
    }
}

