/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateDataKeyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GenerateDataKeyResponse> {
    private final ByteBuffer ciphertextBlob;
    private final ByteBuffer plaintext;
    private final String keyId;

    private GenerateDataKeyResponse(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.plaintext = builder.plaintext;
        this.keyId = builder.keyId;
    }

    public ByteBuffer ciphertextBlob() {
        return this.ciphertextBlob == null ? null : this.ciphertextBlob.asReadOnlyBuffer();
    }

    public ByteBuffer plaintext() {
        return this.plaintext == null ? null : this.plaintext.asReadOnlyBuffer();
    }

    public String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ciphertextBlob() == null ? 0 : this.ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + (this.plaintext() == null ? 0 : this.plaintext().hashCode());
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyResponse)) {
            return false;
        }
        GenerateDataKeyResponse other = (GenerateDataKeyResponse)((Object)obj);
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.plaintext() == null ^ this.plaintext() == null) {
            return false;
        }
        if (other.plaintext() != null && !other.plaintext().equals(this.plaintext())) {
            return false;
        }
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        return other.keyId() == null || other.keyId().equals(this.keyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(this.ciphertextBlob()).append(",");
        }
        if (this.plaintext() != null) {
            sb.append("Plaintext: ").append(this.plaintext()).append(",");
        }
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.of(clazz.cast(this.ciphertextBlob()));
            }
            case "Plaintext": {
                return Optional.of(clazz.cast(this.plaintext()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ByteBuffer ciphertextBlob;
        private ByteBuffer plaintext;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyResponse model) {
            this.ciphertextBlob(model.ciphertextBlob);
            this.plaintext(model.plaintext);
            this.keyId(model.keyId);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public GenerateDataKeyResponse build() {
            return new GenerateDataKeyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenerateDataKeyResponse> {
        public Builder ciphertextBlob(ByteBuffer var1);

        public Builder plaintext(ByteBuffer var1);

        public Builder keyId(String var1);
    }
}

