/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.kms.model.GrantListCopier;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRetirableGrantsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRetirableGrantsResponse> {
    private final List<GrantListEntry> grants;
    private final String nextMarker;
    private final Boolean truncated;

    private ListRetirableGrantsResponse(BuilderImpl builder) {
        this.grants = builder.grants;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public List<GrantListEntry> grants() {
        return this.grants;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.grants() == null ? 0 : this.grants().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.truncated() == null ? 0 : this.truncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetirableGrantsResponse)) {
            return false;
        }
        ListRetirableGrantsResponse other = (ListRetirableGrantsResponse)((Object)obj);
        if (other.grants() == null ^ this.grants() == null) {
            return false;
        }
        if (other.grants() != null && !other.grants().equals(this.grants())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.truncated() == null ^ this.truncated() == null) {
            return false;
        }
        return other.truncated() == null || other.truncated().equals(this.truncated());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.grants() != null) {
            sb.append("Grants: ").append(this.grants()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.truncated() != null) {
            sb.append("Truncated: ").append(this.truncated()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GrantListEntry> grants;
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetirableGrantsResponse model) {
            this.setGrants(model.grants);
            this.setNextMarker(model.nextMarker);
            this.setTruncated(model.truncated);
        }

        public final Collection<GrantListEntry> getGrants() {
            return this.grants;
        }

        @Override
        public final Builder grants(Collection<GrantListEntry> grants) {
            this.grants = GrantListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(GrantListEntry ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        public final void setGrants(Collection<GrantListEntry> grants) {
            this.grants = GrantListCopier.copy(grants);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        public ListRetirableGrantsResponse build() {
            return new ListRetirableGrantsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRetirableGrantsResponse> {
        public Builder grants(Collection<GrantListEntry> var1);

        public Builder grants(GrantListEntry ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

