/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.model.KeyMetadata;

public class KeyMetadataUnmarshaller
implements Unmarshaller<KeyMetadata, JsonUnmarshallerContext> {
    private static final KeyMetadataUnmarshaller INSTANCE = new KeyMetadataUnmarshaller();

    public KeyMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyMetadata.Builder keyMetadataBuilder = KeyMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("AWSAccountId", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.awsAccountId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.keyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.creationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.enabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeyUsage", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.keyUsage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeyState", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.keyState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeletionDate", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.deletionDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ValidTo", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.validTo((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Origin", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.origin((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExpirationModel", targetDepth)) {
                    context.nextToken();
                    keyMetadataBuilder.expirationModel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeyMetadata)keyMetadataBuilder.build();
    }

    public static KeyMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

