/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kms.model.TagKeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UntagResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UntagResourceRequest> {
    private final String keyId;
    private final List<String> tagKeys;

    private UntagResourceRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.tagKeys = builder.tagKeys;
    }

    public String keyId() {
        return this.keyId;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.tagKeys() == null ? 0 : this.tagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        return other.tagKeys() == null || other.tagKeys().equals(this.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourceRequest model) {
            this.setKeyId(model.keyId);
            this.setTagKeys(model.tagKeys);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        public UntagResourceRequest build() {
            return new UntagResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UntagResourceRequest> {
        public Builder keyId(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);
    }
}

