/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.TagMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Tag
implements StructuredPojo,
ToCopyableBuilder<Builder, Tag> {
    private final String tagKey;
    private final String tagValue;

    private Tag(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
    }

    public String tagKey() {
        return this.tagKey;
    }

    public String tagValue() {
        return this.tagValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tagKey() == null ? 0 : this.tagKey().hashCode());
        hashCode = 31 * hashCode + (this.tagValue() == null ? 0 : this.tagValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        if (other.tagKey() == null ^ this.tagKey() == null) {
            return false;
        }
        if (other.tagKey() != null && !other.tagKey().equals(this.tagKey())) {
            return false;
        }
        if (other.tagValue() == null ^ this.tagValue() == null) {
            return false;
        }
        return other.tagValue() == null || other.tagValue().equals(this.tagValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tagKey() != null) {
            sb.append("TagKey: ").append(this.tagKey()).append(",");
        }
        if (this.tagValue() != null) {
            sb.append("TagValue: ").append(this.tagValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String tagKey;
        private String tagValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            this.setTagKey(model.tagKey);
            this.setTagValue(model.tagValue);
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        public Tag build() {
            return new Tag(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Tag> {
        public Builder tagKey(String var1);

        public Builder tagValue(String var1);
    }
}

