/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kms.model.DataKeySpec;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateDataKeyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GenerateDataKeyRequest> {
    private final String keyId;
    private final Map<String, String> encryptionContext;
    private final Integer numberOfBytes;
    private final String keySpec;
    private final List<String> grantTokens;

    private GenerateDataKeyRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.encryptionContext = builder.encryptionContext;
        this.numberOfBytes = builder.numberOfBytes;
        this.keySpec = builder.keySpec;
        this.grantTokens = builder.grantTokens;
    }

    public String keyId() {
        return this.keyId;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Integer numberOfBytes() {
        return this.numberOfBytes;
    }

    public String keySpec() {
        return this.keySpec;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.encryptionContext() == null ? 0 : this.encryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.numberOfBytes() == null ? 0 : this.numberOfBytes().hashCode());
        hashCode = 31 * hashCode + (this.keySpec() == null ? 0 : this.keySpec().hashCode());
        hashCode = 31 * hashCode + (this.grantTokens() == null ? 0 : this.grantTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyRequest)) {
            return false;
        }
        GenerateDataKeyRequest other = (GenerateDataKeyRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.encryptionContext() == null ^ this.encryptionContext() == null) {
            return false;
        }
        if (other.encryptionContext() != null && !other.encryptionContext().equals(this.encryptionContext())) {
            return false;
        }
        if (other.numberOfBytes() == null ^ this.numberOfBytes() == null) {
            return false;
        }
        if (other.numberOfBytes() != null && !other.numberOfBytes().equals(this.numberOfBytes())) {
            return false;
        }
        if (other.keySpec() == null ^ this.keySpec() == null) {
            return false;
        }
        if (other.keySpec() != null && !other.keySpec().equals(this.keySpec())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        return other.grantTokens() == null || other.grantTokens().equals(this.grantTokens());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.encryptionContext() != null) {
            sb.append("EncryptionContext: ").append(this.encryptionContext()).append(",");
        }
        if (this.numberOfBytes() != null) {
            sb.append("NumberOfBytes: ").append(this.numberOfBytes()).append(",");
        }
        if (this.keySpec() != null) {
            sb.append("KeySpec: ").append(this.keySpec()).append(",");
        }
        if (this.grantTokens() != null) {
            sb.append("GrantTokens: ").append(this.grantTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private Map<String, String> encryptionContext;
        private Integer numberOfBytes;
        private String keySpec;
        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyRequest model) {
            this.setKeyId(model.keyId);
            this.setEncryptionContext(model.encryptionContext);
            this.setNumberOfBytes(model.numberOfBytes);
            this.setKeySpec(model.keySpec);
            this.setGrantTokens(model.grantTokens);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final Integer getNumberOfBytes() {
            return this.numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        public final String getKeySpec() {
            return this.keySpec;
        }

        @Override
        public final Builder keySpec(String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        @Override
        public final Builder keySpec(DataKeySpec keySpec) {
            this.keySpec(keySpec.toString());
            return this;
        }

        public final void setKeySpec(String keySpec) {
            this.keySpec = keySpec;
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        public GenerateDataKeyRequest build() {
            return new GenerateDataKeyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenerateDataKeyRequest> {
        public Builder keyId(String var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder numberOfBytes(Integer var1);

        public Builder keySpec(String var1);

        public Builder keySpec(DataKeySpec var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);
    }
}

