/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutKeyPolicyRequestMarshaller
implements Marshaller<Request<PutKeyPolicyRequest>, PutKeyPolicyRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("TrentService.PutKeyPolicy").serviceName("KMS").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public PutKeyPolicyRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutKeyPolicyRequest> marshall(PutKeyPolicyRequest putKeyPolicyRequest) {
        Validate.paramNotNull((Object)((Object)putKeyPolicyRequest), (String)"putKeyPolicyRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)putKeyPolicyRequest);
            protocolMarshaller.startMarshalling();
            PutKeyPolicyRequestModelMarshaller.getInstance().marshall(putKeyPolicyRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

