/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.transform.GrantConstraintsUnmarshaller;

public class GrantListEntryUnmarshaller
implements Unmarshaller<GrantListEntry, JsonUnmarshallerContext> {
    private static final GrantListEntryUnmarshaller INSTANCE = new GrantListEntryUnmarshaller();

    public GrantListEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        GrantListEntry.Builder grantListEntryBuilder = GrantListEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.keyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("GrantId", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.grantId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.creationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("GranteePrincipal", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.granteePrincipal((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RetiringPrincipal", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.retiringPrincipal((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("IssuingAccount", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.issuingAccount((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Operations", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.operationsWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Constraints", targetDepth)) {
                    context.nextToken();
                    grantListEntryBuilder.constraints(GrantConstraintsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GrantListEntry)grantListEntryBuilder.build();
    }

    public static GrantListEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

