/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.GetParametersForImportRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetParametersForImportRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<String> WRAPPINGALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WrappingAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<String> WRAPPINGKEYSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WrappingKeySpec").isBinary(false).build();
    private static final GetParametersForImportRequestModelMarshaller INSTANCE = new GetParametersForImportRequestModelMarshaller();

    private GetParametersForImportRequestModelMarshaller() {
    }

    public static GetParametersForImportRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetParametersForImportRequest getParametersForImportRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getParametersForImportRequest), (String)"getParametersForImportRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getParametersForImportRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)getParametersForImportRequest.wrappingAlgorithmAsString(), WRAPPINGALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)getParametersForImportRequest.wrappingKeySpecAsString(), WRAPPINGKEYSPEC_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

