/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DecryptRequestModelMarshaller {
    private static final MarshallingInfo<SdkBytes> CIPHERTEXTBLOB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CiphertextBlob").isBinary(false).build();
    private static final MarshallingInfo<Map> ENCRYPTIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionContext").isBinary(false).build();
    private static final MarshallingInfo<List> GRANTTOKENS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTokens").isBinary(false).build();
    private static final DecryptRequestModelMarshaller INSTANCE = new DecryptRequestModelMarshaller();

    private DecryptRequestModelMarshaller() {
    }

    public static DecryptRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DecryptRequest decryptRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)decryptRequest), (String)"decryptRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)decryptRequest.ciphertextBlob(), CIPHERTEXTBLOB_BINDING);
            protocolMarshaller.marshall(decryptRequest.encryptionContext(), ENCRYPTIONCONTEXT_BINDING);
            protocolMarshaller.marshall(decryptRequest.grantTokens(), GRANTTOKENS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

