/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetireGrantRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, RetireGrantRequest> {
    private final String grantToken;
    private final String keyId;
    private final String grantId;

    private RetireGrantRequest(BuilderImpl builder) {
        super(builder);
        this.grantToken = builder.grantToken;
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
    }

    public String grantToken() {
        return this.grantToken;
    }

    public String keyId() {
        return this.keyId;
    }

    public String grantId() {
        return this.grantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grantToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetireGrantRequest)) {
            return false;
        }
        RetireGrantRequest other = (RetireGrantRequest)((Object)obj);
        return Objects.equals(this.grantToken(), other.grantToken()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.grantId(), other.grantId());
    }

    public String toString() {
        return ToString.builder((String)"RetireGrantRequest").add("GrantToken", (Object)this.grantToken()).add("KeyId", (Object)this.keyId()).add("GrantId", (Object)this.grantId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrantToken": {
                return Optional.ofNullable(clazz.cast(this.grantToken()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "GrantId": {
                return Optional.ofNullable(clazz.cast(this.grantId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String grantToken;
        private String keyId;
        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetireGrantRequest model) {
            super(model);
            this.grantToken(model.grantToken);
            this.keyId(model.keyId);
            this.grantId(model.grantId);
        }

        public final String getGrantToken() {
            return this.grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetireGrantRequest build() {
            return new RetireGrantRequest(this);
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    CopyableBuilder<Builder, RetireGrantRequest> {
        public Builder grantToken(String var1);

        public Builder keyId(String var1);

        public Builder grantId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

