/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReEncryptRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, ReEncryptRequest> {
    private final SdkBytes ciphertextBlob;
    private final Map<String, String> sourceEncryptionContext;
    private final String destinationKeyId;
    private final Map<String, String> destinationEncryptionContext;
    private final List<String> grantTokens;

    private ReEncryptRequest(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.sourceEncryptionContext = builder.sourceEncryptionContext;
        this.destinationKeyId = builder.destinationKeyId;
        this.destinationEncryptionContext = builder.destinationEncryptionContext;
        this.grantTokens = builder.grantTokens;
    }

    public SdkBytes ciphertextBlob() {
        return this.ciphertextBlob;
    }

    public Map<String, String> sourceEncryptionContext() {
        return this.sourceEncryptionContext;
    }

    public String destinationKeyId() {
        return this.destinationKeyId;
    }

    public Map<String, String> destinationEncryptionContext() {
        return this.destinationEncryptionContext;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEncryptionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEncryptionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptRequest)) {
            return false;
        }
        ReEncryptRequest other = (ReEncryptRequest)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && Objects.equals(this.sourceEncryptionContext(), other.sourceEncryptionContext()) && Objects.equals(this.destinationKeyId(), other.destinationKeyId()) && Objects.equals(this.destinationEncryptionContext(), other.destinationEncryptionContext()) && Objects.equals(this.grantTokens(), other.grantTokens());
    }

    public String toString() {
        return ToString.builder((String)"ReEncryptRequest").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("SourceEncryptionContext", this.sourceEncryptionContext()).add("DestinationKeyId", (Object)this.destinationKeyId()).add("DestinationEncryptionContext", this.destinationEncryptionContext()).add("GrantTokens", this.grantTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.ofNullable(clazz.cast(this.ciphertextBlob()));
            }
            case "SourceEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.sourceEncryptionContext()));
            }
            case "DestinationKeyId": {
                return Optional.ofNullable(clazz.cast(this.destinationKeyId()));
            }
            case "DestinationEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.destinationEncryptionContext()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private SdkBytes ciphertextBlob;
        private Map<String, String> sourceEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String destinationKeyId;
        private Map<String, String> destinationEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptRequest model) {
            super(model);
            this.ciphertextBlob(model.ciphertextBlob);
            this.sourceEncryptionContext(model.sourceEncryptionContext);
            this.destinationKeyId(model.destinationKeyId);
            this.destinationEncryptionContext(model.destinationEncryptionContext);
            this.grantTokens(model.grantTokens);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob == null ? null : this.ciphertextBlob.asByteBuffer();
        }

        @Override
        public final Builder ciphertextBlob(SdkBytes ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((SdkBytes)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob(ciphertextBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextBlob));
        }

        public final Map<String, String> getSourceEncryptionContext() {
            return this.sourceEncryptionContext;
        }

        @Override
        public final Builder sourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
            return this;
        }

        public final void setSourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
        }

        public final String getDestinationKeyId() {
            return this.destinationKeyId;
        }

        @Override
        public final Builder destinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
            return this;
        }

        public final void setDestinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
        }

        public final Map<String, String> getDestinationEncryptionContext() {
            return this.destinationEncryptionContext;
        }

        @Override
        public final Builder destinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
            return this;
        }

        public final void setDestinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReEncryptRequest build() {
            return new ReEncryptRequest(this);
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    CopyableBuilder<Builder, ReEncryptRequest> {
        public Builder ciphertextBlob(SdkBytes var1);

        public Builder sourceEncryptionContext(Map<String, String> var1);

        public Builder destinationKeyId(String var1);

        public Builder destinationEncryptionContext(Map<String, String> var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

