/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.GrantListCopier;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRetirableGrantsResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, ListRetirableGrantsResponse> {
    private final List<GrantListEntry> grants;
    private final String nextMarker;
    private final Boolean truncated;

    private ListRetirableGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.grants = builder.grants;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public List<GrantListEntry> grants() {
        return this.grants;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grants());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetirableGrantsResponse)) {
            return false;
        }
        ListRetirableGrantsResponse other = (ListRetirableGrantsResponse)((Object)obj);
        return Objects.equals(this.grants(), other.grants()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.truncated(), other.truncated());
    }

    public String toString() {
        return ToString.builder((String)"ListRetirableGrantsResponse").add("Grants", this.grants()).add("NextMarker", (Object)this.nextMarker()).add("Truncated", (Object)this.truncated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Grants": {
                return Optional.ofNullable(clazz.cast(this.grants()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private List<GrantListEntry> grants = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetirableGrantsResponse model) {
            super(model);
            this.grants(model.grants);
            this.nextMarker(model.nextMarker);
            this.truncated(model.truncated);
        }

        public final Collection<GrantListEntry.Builder> getGrants() {
            return this.grants != null ? (Collection)this.grants.stream().map(GrantListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder grants(Collection<GrantListEntry> grants) {
            this.grants = GrantListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(GrantListEntry ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<GrantListEntry.Builder> ... grants) {
            this.grants(Stream.of(grants).map(c -> (GrantListEntry)((GrantListEntry.Builder)GrantListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGrants(Collection<GrantListEntry.BuilderImpl> grants) {
            this.grants = GrantListCopier.copyFromBuilder(grants);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public ListRetirableGrantsResponse build() {
            return new ListRetirableGrantsResponse(this);
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    CopyableBuilder<Builder, ListRetirableGrantsResponse> {
        public Builder grants(Collection<GrantListEntry> var1);

        public Builder grants(GrantListEntry ... var1);

        public Builder grants(Consumer<GrantListEntry.Builder> ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

