/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KeyState {
    ENABLED("Enabled"),
    DISABLED("Disabled"),
    PENDING_DELETION("PendingDeletion"),
    PENDING_IMPORT("PendingImport"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private KeyState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(KeyState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyState> knownValues() {
        return Stream.of(KeyState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

