/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.KeyListEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyListEntry> {
    private final String keyId;
    private final String keyArn;

    private KeyListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.keyArn = builder.keyArn;
    }

    public String keyId() {
        return this.keyId;
    }

    public String keyArn() {
        return this.keyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyListEntry)) {
            return false;
        }
        KeyListEntry other = (KeyListEntry)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.keyArn(), other.keyArn());
    }

    public String toString() {
        return ToString.builder((String)"KeyListEntry").add("KeyId", (Object)this.keyId()).add("KeyArn", (Object)this.keyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "KeyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String keyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyListEntry model) {
            this.keyId(model.keyId);
            this.keyArn(model.keyArn);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        public KeyListEntry build() {
            return new KeyListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyListEntry> {
        public Builder keyId(String var1);

        public Builder keyArn(String var1);
    }
}

