/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParametersForImportResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GetParametersForImportResponse> {
    private final String keyId;
    private final SdkBytes importToken;
    private final SdkBytes publicKey;
    private final Instant parametersValidTo;

    private GetParametersForImportResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.importToken = builder.importToken;
        this.publicKey = builder.publicKey;
        this.parametersValidTo = builder.parametersValidTo;
    }

    public String keyId() {
        return this.keyId;
    }

    public SdkBytes importToken() {
        return this.importToken;
    }

    public SdkBytes publicKey() {
        return this.publicKey;
    }

    public Instant parametersValidTo() {
        return this.parametersValidTo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.parametersValidTo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportResponse)) {
            return false;
        }
        GetParametersForImportResponse other = (GetParametersForImportResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.importToken(), other.importToken()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.parametersValidTo(), other.parametersValidTo());
    }

    public String toString() {
        return ToString.builder((String)"GetParametersForImportResponse").add("KeyId", (Object)this.keyId()).add("ImportToken", (Object)this.importToken()).add("PublicKey", (Object)this.publicKey()).add("ParametersValidTo", (Object)this.parametersValidTo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "ImportToken": {
                return Optional.ofNullable(clazz.cast(this.importToken()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "ParametersValidTo": {
                return Optional.ofNullable(clazz.cast(this.parametersValidTo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes importToken;
        private SdkBytes publicKey;
        private Instant parametersValidTo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.importToken(model.importToken);
            this.publicKey(model.publicKey);
            this.parametersValidTo(model.parametersValidTo);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getImportToken() {
            return this.importToken == null ? null : this.importToken.asByteBuffer();
        }

        @Override
        public final Builder importToken(SdkBytes importToken) {
            this.importToken = StandardMemberCopier.copy((SdkBytes)importToken);
            return this;
        }

        public final void setImportToken(ByteBuffer importToken) {
            this.importToken(importToken == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)importToken));
        }

        public final ByteBuffer getPublicKey() {
            return this.publicKey == null ? null : this.publicKey.asByteBuffer();
        }

        @Override
        public final Builder publicKey(SdkBytes publicKey) {
            this.publicKey = StandardMemberCopier.copy((SdkBytes)publicKey);
            return this;
        }

        public final void setPublicKey(ByteBuffer publicKey) {
            this.publicKey(publicKey == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)publicKey));
        }

        public final Instant getParametersValidTo() {
            return this.parametersValidTo;
        }

        @Override
        public final Builder parametersValidTo(Instant parametersValidTo) {
            this.parametersValidTo = parametersValidTo;
            return this;
        }

        public final void setParametersValidTo(Instant parametersValidTo) {
            this.parametersValidTo = parametersValidTo;
        }

        @Override
        public GetParametersForImportResponse build() {
            return new GetParametersForImportResponse(this);
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    CopyableBuilder<Builder, GetParametersForImportResponse> {
        public Builder keyId(String var1);

        public Builder importToken(SdkBytes var1);

        public Builder publicKey(SdkBytes var1);

        public Builder parametersValidTo(Instant var1);
    }
}

