/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecryptResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, DecryptResponse> {
    private final String keyId;
    private final SdkBytes plaintext;

    private DecryptResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.plaintext = builder.plaintext;
    }

    public String keyId() {
        return this.keyId;
    }

    public SdkBytes plaintext() {
        return this.plaintext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptResponse)) {
            return false;
        }
        DecryptResponse other = (DecryptResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.plaintext(), other.plaintext());
    }

    public String toString() {
        return ToString.builder((String)"DecryptResponse").add("KeyId", (Object)this.keyId()).add("Plaintext", (Object)this.plaintext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Plaintext": {
                return Optional.ofNullable(clazz.cast(this.plaintext()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes plaintext;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.plaintext(model.plaintext);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext == null ? null : this.plaintext.asByteBuffer();
        }

        @Override
        public final Builder plaintext(SdkBytes plaintext) {
            this.plaintext = StandardMemberCopier.copy((SdkBytes)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext(plaintext == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)plaintext));
        }

        @Override
        public DecryptResponse build() {
            return new DecryptResponse(this);
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    CopyableBuilder<Builder, DecryptResponse> {
        public Builder keyId(String var1);

        public Builder plaintext(SdkBytes var1);
    }
}

