/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DecryptRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DecryptRequest> {
    private final ByteBuffer ciphertextBlob;
    private final Map<String, String> encryptionContext;
    private final List<String> grantTokens;

    private DecryptRequest(BuilderImpl builder) {
        this.ciphertextBlob = builder.ciphertextBlob;
        this.encryptionContext = builder.encryptionContext;
        this.grantTokens = builder.grantTokens;
    }

    public ByteBuffer ciphertextBlob() {
        return this.ciphertextBlob;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ciphertextBlob() == null ? 0 : this.ciphertextBlob().hashCode());
        hashCode = 31 * hashCode + (this.encryptionContext() == null ? 0 : this.encryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.grantTokens() == null ? 0 : this.grantTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptRequest)) {
            return false;
        }
        DecryptRequest other = (DecryptRequest)((Object)obj);
        if (other.ciphertextBlob() == null ^ this.ciphertextBlob() == null) {
            return false;
        }
        if (other.ciphertextBlob() != null && !other.ciphertextBlob().equals(this.ciphertextBlob())) {
            return false;
        }
        if (other.encryptionContext() == null ^ this.encryptionContext() == null) {
            return false;
        }
        if (other.encryptionContext() != null && !other.encryptionContext().equals(this.encryptionContext())) {
            return false;
        }
        if (other.grantTokens() == null ^ this.grantTokens() == null) {
            return false;
        }
        return other.grantTokens() == null || other.grantTokens().equals(this.grantTokens());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ciphertextBlob() != null) {
            sb.append("CiphertextBlob: ").append(this.ciphertextBlob()).append(",");
        }
        if (this.encryptionContext() != null) {
            sb.append("EncryptionContext: ").append(this.encryptionContext()).append(",");
        }
        if (this.grantTokens() != null) {
            sb.append("GrantTokens: ").append(this.grantTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ByteBuffer ciphertextBlob;
        private Map<String, String> encryptionContext = new SdkInternalMap();
        private List<String> grantTokens = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptRequest model) {
            this.setCiphertextBlob(model.ciphertextBlob);
            this.setEncryptionContext(model.encryptionContext);
            this.setGrantTokens(model.grantTokens);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
        }

        public final Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            if (this.grantTokens == null) {
                this.grantTokens = new SdkInternalList(grantTokens.length);
            }
            for (String e : grantTokens) {
                this.grantTokens.add(e);
            }
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @SafeVarargs
        public final void setGrantTokens(String ... grantTokens) {
            if (this.grantTokens == null) {
                this.grantTokens = new SdkInternalList(grantTokens.length);
            }
            for (String e : grantTokens) {
                this.grantTokens.add(e);
            }
        }

        public DecryptRequest build() {
            return new DecryptRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DecryptRequest> {
        public Builder ciphertextBlob(ByteBuffer var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);
    }
}

