/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideowebrtcstorage;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.KinesisVideoWebRtcStorageClient;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.AccessDeniedException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionAsViewerRequest;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionAsViewerResponse;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionRequest;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionResponse;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.KinesisVideoWebRtcStorageException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.transform.JoinStorageSessionAsViewerRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.transform.JoinStorageSessionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisVideoWebRtcStorageClient
implements KinesisVideoWebRtcStorageClient {
    private static final Logger log = Logger.loggerFor(DefaultKinesisVideoWebRtcStorageClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisVideoWebRtcStorageClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kinesisvideo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JoinStorageSessionResponse joinStorageSession(JoinStorageSessionRequest joinStorageSessionRequest) throws ClientLimitExceededException, InvalidArgumentException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisVideoWebRtcStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, JoinStorageSessionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoWebRtcStorageClient.resolveMetricPublishers(this.clientConfiguration, joinStorageSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video WebRTC Storage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"JoinStorageSession");
            JoinStorageSessionResponse joinStorageSessionResponse = (JoinStorageSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("JoinStorageSession").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)joinStorageSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new JoinStorageSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return joinStorageSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoWebRtcStorageClient.lambda$joinStorageSession$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JoinStorageSessionAsViewerResponse joinStorageSessionAsViewer(JoinStorageSessionAsViewerRequest joinStorageSessionAsViewerRequest) throws ClientLimitExceededException, InvalidArgumentException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisVideoWebRtcStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, JoinStorageSessionAsViewerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoWebRtcStorageClient.resolveMetricPublishers(this.clientConfiguration, joinStorageSessionAsViewerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video WebRTC Storage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"JoinStorageSessionAsViewer");
            JoinStorageSessionAsViewerResponse joinStorageSessionAsViewerResponse = (JoinStorageSessionAsViewerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("JoinStorageSessionAsViewer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)joinStorageSessionAsViewerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new JoinStorageSessionAsViewerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return joinStorageSessionAsViewerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoWebRtcStorageClient.lambda$joinStorageSessionAsViewer$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisVideoWebRtcStorageException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").exceptionBuilderSupplier(ClientLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$joinStorageSessionAsViewer$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$joinStorageSession$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

