/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaAsyncClient;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse;

public class ListFragmentsPublisher
implements SdkPublisher<ListFragmentsResponse> {
    private final KinesisVideoArchivedMediaAsyncClient client;
    private final ListFragmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFragmentsPublisher(KinesisVideoArchivedMediaAsyncClient client, ListFragmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFragmentsPublisher(KinesisVideoArchivedMediaAsyncClient client, ListFragmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFragmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFragmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Fragment> fragments() {
        Function<ListFragmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fragments() != null) {
                return response.fragments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFragmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFragmentsResponseFetcher
    implements AsyncPageFetcher<ListFragmentsResponse> {
        private ListFragmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListFragmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFragmentsResponse> nextPage(ListFragmentsResponse previousPage) {
            if (previousPage == null) {
                return ListFragmentsPublisher.this.client.listFragments(ListFragmentsPublisher.this.firstRequest);
            }
            return ListFragmentsPublisher.this.client.listFragments((ListFragmentsRequest)((Object)ListFragmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

