/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentListCopier;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFragmentsResponse
extends KinesisVideoArchivedMediaResponse
implements ToCopyableBuilder<Builder, ListFragmentsResponse> {
    private static final SdkField<List<Fragment>> FRAGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fragments").getter(ListFragmentsResponse.getter(ListFragmentsResponse::fragments)).setter(ListFragmentsResponse.setter(Builder::fragments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fragments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Fragment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFragmentsResponse.getter(ListFragmentsResponse::nextToken)).setter(ListFragmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Fragment> fragments;
    private final String nextToken;

    private ListFragmentsResponse(BuilderImpl builder) {
        super(builder);
        this.fragments = builder.fragments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasFragments() {
        return this.fragments != null && !(this.fragments instanceof SdkAutoConstructList);
    }

    public List<Fragment> fragments() {
        return this.fragments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fragments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFragmentsResponse)) {
            return false;
        }
        ListFragmentsResponse other = (ListFragmentsResponse)((Object)obj);
        return Objects.equals(this.fragments(), other.fragments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFragmentsResponse").add("Fragments", this.fragments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fragments": {
                return Optional.ofNullable(clazz.cast(this.fragments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFragmentsResponse, T> g) {
        return obj -> g.apply((ListFragmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaResponse.BuilderImpl
    implements Builder {
        private List<Fragment> fragments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFragmentsResponse model) {
            super(model);
            this.fragments(model.fragments);
            this.nextToken(model.nextToken);
        }

        public final Collection<Fragment.Builder> getFragments() {
            return this.fragments != null ? (Collection)this.fragments.stream().map(Fragment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fragments(Collection<Fragment> fragments) {
            this.fragments = FragmentListCopier.copy(fragments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(Fragment ... fragments) {
            this.fragments(Arrays.asList(fragments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(Consumer<Fragment.Builder> ... fragments) {
            this.fragments(Stream.of(fragments).map(c -> (Fragment)((Fragment.Builder)Fragment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFragments(Collection<Fragment.BuilderImpl> fragments) {
            this.fragments = FragmentListCopier.copyFromBuilder(fragments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFragmentsResponse build() {
            return new ListFragmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoArchivedMediaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFragmentsResponse> {
        public Builder fragments(Collection<Fragment> var1);

        public Builder fragments(Fragment ... var1);

        public Builder fragments(Consumer<Fragment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

