/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSFragmentSelectorType;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSTimestampRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HLSFragmentSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HLSFragmentSelector> {
    private static final SdkField<String> FRAGMENT_SELECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HLSFragmentSelector.getter(HLSFragmentSelector::fragmentSelectorTypeAsString)).setter(HLSFragmentSelector.setter(Builder::fragmentSelectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelectorType").build()}).build();
    private static final SdkField<HLSTimestampRange> TIMESTAMP_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HLSFragmentSelector.getter(HLSFragmentSelector::timestampRange)).setter(HLSFragmentSelector.setter(Builder::timestampRange)).constructor(HLSTimestampRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENT_SELECTOR_TYPE_FIELD, TIMESTAMP_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fragmentSelectorType;
    private final HLSTimestampRange timestampRange;

    private HLSFragmentSelector(BuilderImpl builder) {
        this.fragmentSelectorType = builder.fragmentSelectorType;
        this.timestampRange = builder.timestampRange;
    }

    public HLSFragmentSelectorType fragmentSelectorType() {
        return HLSFragmentSelectorType.fromValue(this.fragmentSelectorType);
    }

    public String fragmentSelectorTypeAsString() {
        return this.fragmentSelectorType;
    }

    public HLSTimestampRange timestampRange() {
        return this.timestampRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampRange());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HLSFragmentSelector)) {
            return false;
        }
        HLSFragmentSelector other = (HLSFragmentSelector)obj;
        return Objects.equals(this.fragmentSelectorTypeAsString(), other.fragmentSelectorTypeAsString()) && Objects.equals(this.timestampRange(), other.timestampRange());
    }

    public String toString() {
        return ToString.builder((String)"HLSFragmentSelector").add("FragmentSelectorType", (Object)this.fragmentSelectorTypeAsString()).add("TimestampRange", (Object)this.timestampRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FragmentSelectorType": {
                return Optional.ofNullable(clazz.cast(this.fragmentSelectorTypeAsString()));
            }
            case "TimestampRange": {
                return Optional.ofNullable(clazz.cast(this.timestampRange()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HLSFragmentSelector, T> g) {
        return obj -> g.apply((HLSFragmentSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fragmentSelectorType;
        private HLSTimestampRange timestampRange;

        private BuilderImpl() {
        }

        private BuilderImpl(HLSFragmentSelector model) {
            this.fragmentSelectorType(model.fragmentSelectorType);
            this.timestampRange(model.timestampRange);
        }

        public final String getFragmentSelectorType() {
            return this.fragmentSelectorType;
        }

        @Override
        public final Builder fragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
            return this;
        }

        @Override
        public final Builder fragmentSelectorType(HLSFragmentSelectorType fragmentSelectorType) {
            this.fragmentSelectorType(fragmentSelectorType == null ? null : fragmentSelectorType.toString());
            return this;
        }

        public final void setFragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
        }

        public final HLSTimestampRange.Builder getTimestampRange() {
            return this.timestampRange != null ? this.timestampRange.toBuilder() : null;
        }

        @Override
        public final Builder timestampRange(HLSTimestampRange timestampRange) {
            this.timestampRange = timestampRange;
            return this;
        }

        public final void setTimestampRange(HLSTimestampRange.BuilderImpl timestampRange) {
            this.timestampRange = timestampRange != null ? timestampRange.build() : null;
        }

        public HLSFragmentSelector build() {
            return new HLSFragmentSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HLSFragmentSelector> {
        public Builder fragmentSelectorType(String var1);

        public Builder fragmentSelectorType(HLSFragmentSelectorType var1);

        public Builder timestampRange(HLSTimestampRange var1);

        default public Builder timestampRange(Consumer<HLSTimestampRange.Builder> timestampRange) {
            return this.timestampRange((HLSTimestampRange)((HLSTimestampRange.Builder)HLSTimestampRange.builder().applyMutation(timestampRange)).build());
        }
    }
}

