/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.StreamStorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamStorageConfigurationRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UpdateStreamStorageConfigurationRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(UpdateStreamStorageConfigurationRequest.getter(UpdateStreamStorageConfigurationRequest::streamName)).setter(UpdateStreamStorageConfigurationRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(UpdateStreamStorageConfigurationRequest.getter(UpdateStreamStorageConfigurationRequest::streamARN)).setter(UpdateStreamStorageConfigurationRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateStreamStorageConfigurationRequest.getter(UpdateStreamStorageConfigurationRequest::currentVersion)).setter(UpdateStreamStorageConfigurationRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()}).build();
    private static final SdkField<StreamStorageConfiguration> STREAM_STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamStorageConfiguration").getter(UpdateStreamStorageConfigurationRequest.getter(UpdateStreamStorageConfigurationRequest::streamStorageConfiguration)).setter(UpdateStreamStorageConfigurationRequest.setter(Builder::streamStorageConfiguration)).constructor(StreamStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamStorageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, CURRENT_VERSION_FIELD, STREAM_STORAGE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStreamStorageConfigurationRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final String streamARN;
    private final String currentVersion;
    private final StreamStorageConfiguration streamStorageConfiguration;

    private UpdateStreamStorageConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.currentVersion = builder.currentVersion;
        this.streamStorageConfiguration = builder.streamStorageConfiguration;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final StreamStorageConfiguration streamStorageConfiguration() {
        return this.streamStorageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStorageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamStorageConfigurationRequest)) {
            return false;
        }
        UpdateStreamStorageConfigurationRequest other = (UpdateStreamStorageConfigurationRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.streamStorageConfiguration(), other.streamStorageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStreamStorageConfigurationRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("CurrentVersion", (Object)this.currentVersion()).add("StreamStorageConfiguration", (Object)this.streamStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "StreamStorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.streamStorageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        map.put("StreamStorageConfiguration", STREAM_STORAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamStorageConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateStreamStorageConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String currentVersion;
        private StreamStorageConfiguration streamStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamStorageConfigurationRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.currentVersion(model.currentVersion);
            this.streamStorageConfiguration(model.streamStorageConfiguration);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final StreamStorageConfiguration.Builder getStreamStorageConfiguration() {
            return this.streamStorageConfiguration != null ? this.streamStorageConfiguration.toBuilder() : null;
        }

        public final void setStreamStorageConfiguration(StreamStorageConfiguration.BuilderImpl streamStorageConfiguration) {
            this.streamStorageConfiguration = streamStorageConfiguration != null ? streamStorageConfiguration.build() : null;
        }

        @Override
        public final Builder streamStorageConfiguration(StreamStorageConfiguration streamStorageConfiguration) {
            this.streamStorageConfiguration = streamStorageConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamStorageConfigurationRequest build() {
            return new UpdateStreamStorageConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStreamStorageConfigurationRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder currentVersion(String var1);

        public Builder streamStorageConfiguration(StreamStorageConfiguration var1);

        default public Builder streamStorageConfiguration(Consumer<StreamStorageConfiguration.Builder> streamStorageConfiguration) {
            return this.streamStorageConfiguration((StreamStorageConfiguration)((StreamStorageConfiguration.Builder)StreamStorageConfiguration.builder().applyMutation(streamStorageConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

