/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStreamStorageConfigurationRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UpdateStreamStorageConfigurationRequest.Builder, UpdateStreamStorageConfigurationRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(UpdateStreamStorageConfigurationRequest::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(UpdateStreamStorageConfigurationRequest::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateStreamStorageConfigurationRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final SdkField<StreamStorageConfiguration> STREAM_STORAGE_CONFIGURATION_FIELD = SdkField
            .<StreamStorageConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("StreamStorageConfiguration")
            .getter(getter(UpdateStreamStorageConfigurationRequest::streamStorageConfiguration))
            .setter(setter(Builder::streamStorageConfiguration))
            .constructor(StreamStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamStorageConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, CURRENT_VERSION_FIELD, STREAM_STORAGE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamName;

    private final String streamARN;

    private final String currentVersion;

    private final StreamStorageConfiguration streamStorageConfiguration;

    private UpdateStreamStorageConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.currentVersion = builder.currentVersion;
        this.streamStorageConfiguration = builder.streamStorageConfiguration;
    }

    /**
     * <p>
     * The name of the stream for which you want to update the storage configuration.
     * </p>
     * 
     * @return The name of the stream for which you want to update the storage configuration.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream for which you want to update the storage configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream for which you want to update the storage configuration.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The version of the stream whose storage configuration you want to change. To get the version, call either the
     * <code>DescribeStream</code> or the <code>ListStreams</code> API.
     * </p>
     * 
     * @return The version of the stream whose storage configuration you want to change. To get the version, call either
     *         the <code>DescribeStream</code> or the <code>ListStreams</code> API.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The new storage configuration for the stream. This includes the default storage tier that determines how stream
     * data is stored and accessed.
     * </p>
     * <p>
     * Different storage tiers offer varying levels of performance and cost optimization to match your specific use case
     * requirements.
     * </p>
     * 
     * @return The new storage configuration for the stream. This includes the default storage tier that determines how
     *         stream data is stored and accessed.</p>
     *         <p>
     *         Different storage tiers offer varying levels of performance and cost optimization to match your specific
     *         use case requirements.
     */
    public final StreamStorageConfiguration streamStorageConfiguration() {
        return streamStorageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(streamStorageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamStorageConfigurationRequest)) {
            return false;
        }
        UpdateStreamStorageConfigurationRequest other = (UpdateStreamStorageConfigurationRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(streamStorageConfiguration(), other.streamStorageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStreamStorageConfigurationRequest").add("StreamName", streamName())
                .add("StreamARN", streamARN()).add("CurrentVersion", currentVersion())
                .add("StreamStorageConfiguration", streamStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "StreamStorageConfiguration":
            return Optional.ofNullable(clazz.cast(streamStorageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        map.put("StreamStorageConfiguration", STREAM_STORAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamStorageConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateStreamStorageConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateStreamStorageConfigurationRequest> {
        /**
         * <p>
         * The name of the stream for which you want to update the storage configuration.
         * </p>
         * 
         * @param streamName
         *        The name of the stream for which you want to update the storage configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream for which you want to update the storage configuration.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream for which you want to update the storage configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The version of the stream whose storage configuration you want to change. To get the version, call either the
         * <code>DescribeStream</code> or the <code>ListStreams</code> API.
         * </p>
         * 
         * @param currentVersion
         *        The version of the stream whose storage configuration you want to change. To get the version, call
         *        either the <code>DescribeStream</code> or the <code>ListStreams</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The new storage configuration for the stream. This includes the default storage tier that determines how
         * stream data is stored and accessed.
         * </p>
         * <p>
         * Different storage tiers offer varying levels of performance and cost optimization to match your specific use
         * case requirements.
         * </p>
         * 
         * @param streamStorageConfiguration
         *        The new storage configuration for the stream. This includes the default storage tier that determines
         *        how stream data is stored and accessed.</p>
         *        <p>
         *        Different storage tiers offer varying levels of performance and cost optimization to match your
         *        specific use case requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamStorageConfiguration(StreamStorageConfiguration streamStorageConfiguration);

        /**
         * <p>
         * The new storage configuration for the stream. This includes the default storage tier that determines how
         * stream data is stored and accessed.
         * </p>
         * <p>
         * Different storage tiers offer varying levels of performance and cost optimization to match your specific use
         * case requirements.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamStorageConfiguration.Builder}
         * avoiding the need to create one manually via {@link StreamStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamStorageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #streamStorageConfiguration(StreamStorageConfiguration)}.
         * 
         * @param streamStorageConfiguration
         *        a consumer that will call methods on {@link StreamStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamStorageConfiguration(StreamStorageConfiguration)
         */
        default Builder streamStorageConfiguration(Consumer<StreamStorageConfiguration.Builder> streamStorageConfiguration) {
            return streamStorageConfiguration(StreamStorageConfiguration.builder().applyMutation(streamStorageConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private String currentVersion;

        private StreamStorageConfiguration streamStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamStorageConfigurationRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            currentVersion(model.currentVersion);
            streamStorageConfiguration(model.streamStorageConfiguration);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final StreamStorageConfiguration.Builder getStreamStorageConfiguration() {
            return streamStorageConfiguration != null ? streamStorageConfiguration.toBuilder() : null;
        }

        public final void setStreamStorageConfiguration(StreamStorageConfiguration.BuilderImpl streamStorageConfiguration) {
            this.streamStorageConfiguration = streamStorageConfiguration != null ? streamStorageConfiguration.build() : null;
        }

        @Override
        public final Builder streamStorageConfiguration(StreamStorageConfiguration streamStorageConfiguration) {
            this.streamStorageConfiguration = streamStorageConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamStorageConfigurationRequest build() {
            return new UpdateStreamStorageConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
